/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.torrent.peer;

import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.EasyMockRunner;
import org.easymock.EasyMockSupport;
import org.johnnei.javatorrent.bittorrent.protocol.messages.IMessage;
import org.johnnei.javatorrent.bittorrent.protocol.messages.MessageBlock;
import org.johnnei.javatorrent.bittorrent.protocol.messages.MessageCancel;
import org.johnnei.javatorrent.bittorrent.protocol.messages.MessageChoke;
import org.johnnei.javatorrent.bittorrent.protocol.messages.MessageInterested;
import org.johnnei.javatorrent.bittorrent.protocol.messages.MessageKeepAlive;
import org.johnnei.javatorrent.bittorrent.protocol.messages.MessageRequest;
import org.johnnei.javatorrent.bittorrent.protocol.messages.MessageUnchoke;
import org.johnnei.javatorrent.bittorrent.protocol.messages.MessageUninterested;
import org.johnnei.javatorrent.disk.DiskJobReadBlock;
import org.johnnei.javatorrent.disk.IDiskJob;
import org.johnnei.javatorrent.network.BitTorrentSocket;
import org.johnnei.javatorrent.test.DummyEntity;
import org.johnnei.javatorrent.test.TestUtils;
import org.johnnei.javatorrent.torrent.AbstractFileSet;
import org.johnnei.javatorrent.torrent.Torrent;
import org.johnnei.javatorrent.torrent.files.BlockStatus;
import org.johnnei.javatorrent.torrent.files.Piece;
import org.johnnei.javatorrent.torrent.peer.Peer;
import org.johnnei.javatorrent.torrent.peer.PeerDirection;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;

@RunWith(value=EasyMockRunner.class)
public class PeerTest
extends EasyMockSupport {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testBuilderSetExtensionBytesIncorrectLength() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Extension bytes");
        new Peer.Builder().setExtensionBytes(new byte[9]);
    }

    @Test
    public void testBuilderSetIdIncorrectLength() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Id bytes");
        new Peer.Builder().setId(new byte[9]);
    }

    @Test
    public void testAddModuleInfo() {
        Peer peer = DummyEntity.createPeer();
        Object o = new Object();
        peer.addModuleInfo(o);
        Object returnedO = peer.getModuleInfo(Object.class).get();
        Assert.assertEquals((String)"Returned object is not equal to inserted", (Object)o, returnedO);
    }

    @Test(expected=IllegalStateException.class)
    public void testAddModuleInfoDuplicate() {
        Peer peer = DummyEntity.createPeer();
        Object o = new Object();
        Object o2 = new Object();
        peer.addModuleInfo(o);
        peer.addModuleInfo(o2);
    }

    @Test
    public void testAddModuleInfoNoElement() {
        Peer peer = DummyEntity.createPeer();
        Optional o = peer.getModuleInfo(Object.class);
        Assert.assertFalse((String)"Expected empty result", (boolean)o.isPresent());
    }

    @Test
    public void testDownloadInterested() {
        Torrent torrentMock = new Torrent.Builder().setName("StubTorrent").build();
        BitTorrentSocket socketMock = (BitTorrentSocket)this.createMock(BitTorrentSocket.class);
        Peer peer = DummyEntity.createPeer(socketMock, torrentMock);
        socketMock.enqueueMessage((IMessage)EasyMock.isA(MessageInterested.class));
        this.replayAll();
        peer.setInterested(PeerDirection.Download, true);
        Assert.assertTrue((String)"Incorrect interested state", (boolean)peer.isInterested(PeerDirection.Download));
        this.verifyAll();
    }

    @Test
    public void testDownloadUninterested() {
        Torrent torrentMock = new Torrent.Builder().setName("StubTorrent").build();
        BitTorrentSocket socketMock = (BitTorrentSocket)this.createMock(BitTorrentSocket.class);
        Peer peer = DummyEntity.createPeer(socketMock, torrentMock);
        socketMock.enqueueMessage((IMessage)EasyMock.isA(MessageUninterested.class));
        this.replayAll();
        peer.setInterested(PeerDirection.Download, false);
        Assert.assertFalse((String)"Incorrect interested state", (boolean)peer.isInterested(PeerDirection.Download));
        this.verifyAll();
    }

    @Test
    public void testUploadInterested() {
        Torrent torrentMock = new Torrent.Builder().setName("StubTorrent").build();
        BitTorrentSocket socketMock = (BitTorrentSocket)this.createMock(BitTorrentSocket.class);
        Peer peer = DummyEntity.createPeer(socketMock, torrentMock);
        this.replayAll();
        peer.setInterested(PeerDirection.Upload, true);
        Assert.assertTrue((String)"Incorrect interested state", (boolean)peer.isInterested(PeerDirection.Upload));
        peer.setInterested(PeerDirection.Upload, false);
        Assert.assertFalse((String)"Incorrect interested state", (boolean)peer.isInterested(PeerDirection.Upload));
    }

    @Test
    public void testDownloadChoke() {
        Torrent torrentMock = new Torrent.Builder().setName("StubTorrent").build();
        BitTorrentSocket socketMock = (BitTorrentSocket)this.createMock(BitTorrentSocket.class);
        Peer peer = DummyEntity.createPeer(socketMock, torrentMock);
        this.replayAll();
        peer.setChoked(PeerDirection.Download, true);
        Assert.assertTrue((String)"Incorrect choked state", (boolean)peer.isChoked(PeerDirection.Download));
        peer.setChoked(PeerDirection.Download, false);
        Assert.assertFalse((String)"Incorrect choked state", (boolean)peer.isChoked(PeerDirection.Download));
        this.verifyAll();
    }

    @Test
    public void testUploadChoke() {
        Torrent torrentMock = new Torrent.Builder().setName("StubTorrent").build();
        BitTorrentSocket socketMock = (BitTorrentSocket)this.createMock(BitTorrentSocket.class);
        Peer peer = DummyEntity.createPeer(socketMock, torrentMock);
        socketMock.enqueueMessage((IMessage)EasyMock.isA(MessageChoke.class));
        this.replayAll();
        peer.setChoked(PeerDirection.Upload, true);
        Assert.assertTrue((String)"Incorrect choked state", (boolean)peer.isChoked(PeerDirection.Upload));
        this.verifyAll();
    }

    @Test
    public void testDownloadUnchoke() {
        Torrent torrentMock = new Torrent.Builder().setName("StubTorrent").build();
        BitTorrentSocket socketMock = (BitTorrentSocket)this.createMock(BitTorrentSocket.class);
        Peer peer = DummyEntity.createPeer(socketMock, torrentMock);
        socketMock.enqueueMessage((IMessage)EasyMock.isA(MessageUnchoke.class));
        this.replayAll();
        peer.setChoked(PeerDirection.Upload, false);
        Assert.assertFalse((String)"Incorrect choked state", (boolean)peer.isChoked(PeerDirection.Upload));
        this.verifyAll();
    }

    @Test
    public void testEquality() {
        Torrent torrent = DummyEntity.createUniqueTorrent(new Torrent[0]);
        BitTorrentSocket socketMock = (BitTorrentSocket)this.createMock(BitTorrentSocket.class);
        this.replayAll();
        byte[] peerId = DummyEntity.createUniquePeerId(new byte[0][]);
        byte[] peerIdTwo = DummyEntity.createUniquePeerId(new byte[][]{peerId});
        Peer base = new Peer.Builder().setSocket(socketMock).setTorrent(torrent).setExtensionBytes(DummyEntity.createRandomBytes(8)).setId(peerId).build();
        Peer equal = new Peer.Builder().setSocket(socketMock).setTorrent(torrent).setExtensionBytes(DummyEntity.createRandomBytes(8)).setId(peerId).build();
        Peer notEqual = new Peer.Builder().setSocket(socketMock).setTorrent(torrent).setExtensionBytes(DummyEntity.createRandomBytes(8)).setId(peerIdTwo).build();
        TestUtils.assertEqualityMethods(base, equal, notEqual);
    }

    @Test
    public void testAddBlockRequestDownload() {
        Torrent torrentMock = (Torrent)this.createMock(Torrent.class);
        BitTorrentSocket socketMock = (BitTorrentSocket)this.createMock(BitTorrentSocket.class);
        AbstractFileSet fileSetMock = (AbstractFileSet)this.createMock(AbstractFileSet.class);
        EasyMock.expect((Object)torrentMock.getFileSet()).andStubReturn((Object)fileSetMock);
        EasyMock.expect((Object)fileSetMock.getBlockSize()).andStubReturn((Object)15);
        EasyMock.expect((Object)fileSetMock.getBitfieldBytes()).andStubReturn((Object)new byte[1]);
        socketMock.enqueueMessage((IMessage)EasyMock.isA(MessageRequest.class));
        this.replayAll();
        Peer peer = DummyEntity.createPeer(socketMock, torrentMock);
        peer.addBlockRequest(0, 15, 15, PeerDirection.Download);
        this.verifyAll();
        Assert.assertEquals((String)"Working queue should have increased", (long)1L, (long)peer.getWorkQueueSize(PeerDirection.Download));
    }

    @Test
    public void testAddBlockRequestUpload() {
        Torrent torrentMock = (Torrent)this.createMock(Torrent.class);
        BitTorrentSocket socketMock = (BitTorrentSocket)this.createMock(BitTorrentSocket.class);
        AbstractFileSet fileSetMock = (AbstractFileSet)this.createMock(AbstractFileSet.class);
        EasyMock.expect((Object)torrentMock.getFileSet()).andStubReturn((Object)fileSetMock);
        EasyMock.expect((Object)fileSetMock.getBlockSize()).andStubReturn((Object)15);
        EasyMock.expect((Object)fileSetMock.getBitfieldBytes()).andStubReturn((Object)new byte[1]);
        this.replayAll();
        Peer peer = DummyEntity.createPeer(socketMock, torrentMock);
        peer.addBlockRequest(0, 15, 15, PeerDirection.Upload);
        this.verifyAll();
        Assert.assertEquals((String)"Working queue should have increased", (long)1L, (long)peer.getWorkQueueSize(PeerDirection.Upload));
    }

    @Test
    public void testCancelBlockRequestDownload() {
        Torrent torrentMock = (Torrent)this.createMock(Torrent.class);
        BitTorrentSocket socketMock = (BitTorrentSocket)this.createMock(BitTorrentSocket.class);
        AbstractFileSet fileSetMock = (AbstractFileSet)this.createMock(AbstractFileSet.class);
        EasyMock.expect((Object)torrentMock.getFileSet()).andStubReturn((Object)fileSetMock);
        EasyMock.expect((Object)fileSetMock.getBlockSize()).andStubReturn((Object)15);
        EasyMock.expect((Object)fileSetMock.getBitfieldBytes()).andStubReturn((Object)new byte[1]);
        socketMock.enqueueMessage((IMessage)EasyMock.isA(MessageRequest.class));
        socketMock.enqueueMessage((IMessage)EasyMock.isA(MessageRequest.class));
        socketMock.enqueueMessage((IMessage)EasyMock.isA(MessageCancel.class));
        this.replayAll();
        Peer peer = DummyEntity.createPeer(socketMock, torrentMock);
        peer.addBlockRequest(0, 15, 15, PeerDirection.Download);
        peer.addBlockRequest(0, 30, 15, PeerDirection.Download);
        Assert.assertEquals((String)"Working queue should have two items", (long)2L, (long)peer.getWorkQueueSize(PeerDirection.Download));
        peer.cancelBlockRequest(0, 15, 15, PeerDirection.Download);
        this.verifyAll();
        Assert.assertEquals((String)"Working queue should have one item anymore", (long)1L, (long)peer.getWorkQueueSize(PeerDirection.Download));
    }

    @Test
    public void testCancelBlockRequestUpload() {
        Torrent torrentMock = (Torrent)this.createMock(Torrent.class);
        BitTorrentSocket socketMock = (BitTorrentSocket)this.createMock(BitTorrentSocket.class);
        AbstractFileSet fileSetMock = (AbstractFileSet)this.createMock(AbstractFileSet.class);
        EasyMock.expect((Object)torrentMock.getFileSet()).andStubReturn((Object)fileSetMock);
        EasyMock.expect((Object)fileSetMock.getBlockSize()).andStubReturn((Object)15);
        EasyMock.expect((Object)fileSetMock.getBitfieldBytes()).andStubReturn((Object)new byte[1]);
        this.replayAll();
        Peer peer = DummyEntity.createPeer(socketMock, torrentMock);
        peer.addBlockRequest(0, 15, 15, PeerDirection.Upload);
        peer.addBlockRequest(0, 30, 15, PeerDirection.Upload);
        Assert.assertEquals((String)"Working queue should have two items", (long)2L, (long)peer.getWorkQueueSize(PeerDirection.Upload));
        peer.cancelBlockRequest(0, 15, 15, PeerDirection.Upload);
        this.verifyAll();
        Assert.assertEquals((String)"Working queue should have one item anymore", (long)1L, (long)peer.getWorkQueueSize(PeerDirection.Upload));
    }

    @Test
    public void testOnReceivedBlock() {
        Torrent torrentMock = (Torrent)this.createMock(Torrent.class);
        BitTorrentSocket socketMock = (BitTorrentSocket)this.createMock(BitTorrentSocket.class);
        AbstractFileSet fileSetMock = (AbstractFileSet)this.createMock(AbstractFileSet.class);
        Piece pieceMock = (Piece)this.createMock(Piece.class);
        EasyMock.expect((Object)torrentMock.getFileSet()).andStubReturn((Object)fileSetMock);
        EasyMock.expect((Object)fileSetMock.getBlockSize()).andStubReturn((Object)15);
        EasyMock.expect((Object)fileSetMock.getBitfieldBytes()).andStubReturn((Object)new byte[1]);
        EasyMock.expect((Object)fileSetMock.getPiece(EasyMock.eq((int)0))).andReturn((Object)pieceMock);
        EasyMock.expect((Object)pieceMock.getBlockSize(EasyMock.eq((int)1))).andReturn((Object)15);
        socketMock.enqueueMessage((IMessage)EasyMock.isA(MessageRequest.class));
        socketMock.enqueueMessage((IMessage)EasyMock.isA(MessageRequest.class));
        this.replayAll();
        Peer peer = DummyEntity.createPeer(socketMock, torrentMock);
        peer.addBlockRequest(0, 15, 15, PeerDirection.Download);
        peer.addBlockRequest(0, 30, 15, PeerDirection.Download);
        Assert.assertEquals((String)"Working queue should have two items", (long)2L, (long)peer.getWorkQueueSize(PeerDirection.Download));
        peer.onReceivedBlock(0, 15);
        this.verifyAll();
        Assert.assertEquals((String)"Working queue should have one item anymore", (long)1L, (long)peer.getWorkQueueSize(PeerDirection.Download));
    }

    @Test
    public void testQueueNextPieceForSendingNoPendingJobs() {
        Torrent torrentMock = (Torrent)this.createMock(Torrent.class);
        BitTorrentSocket socketMock = (BitTorrentSocket)this.createMock(BitTorrentSocket.class);
        AbstractFileSet fileSetMock = (AbstractFileSet)this.createMock(AbstractFileSet.class);
        EasyMock.expect((Object)torrentMock.getFileSet()).andStubReturn((Object)fileSetMock);
        EasyMock.expect((Object)fileSetMock.getBitfieldBytes()).andStubReturn((Object)new byte[1]);
        this.replayAll();
        Peer cut = new Peer.Builder().setTorrent(torrentMock).setSocket(socketMock).setId(DummyEntity.createUniquePeerId(new byte[0][])).setExtensionBytes(DummyEntity.createRandomBytes(8)).build();
        cut.queueNextPieceForSending();
        this.verifyAll();
    }

    @Test
    public void testQueueNextPieceForSendingSingleRequestOnly() {
        Torrent torrentMock = (Torrent)this.createMock(Torrent.class);
        BitTorrentSocket socketMock = (BitTorrentSocket)this.createMock(BitTorrentSocket.class);
        AbstractFileSet fileSetMock = (AbstractFileSet)this.createMock(AbstractFileSet.class);
        Piece pieceMock = (Piece)this.createMock(Piece.class);
        Capture diskJobCapture = EasyMock.newCapture();
        EasyMock.expect((Object)torrentMock.getFileSet()).andStubReturn((Object)fileSetMock);
        EasyMock.expect((Object)fileSetMock.getBitfieldBytes()).andStubReturn((Object)new byte[1]);
        EasyMock.expect((Object)fileSetMock.getPiece(EasyMock.eq((int)0))).andReturn((Object)pieceMock);
        torrentMock.addDiskJob((IDiskJob)EasyMock.capture((Capture)diskJobCapture));
        this.replayAll();
        Peer cut = new Peer.Builder().setTorrent(torrentMock).setSocket(socketMock).setId(DummyEntity.createUniquePeerId(new byte[0][])).setExtensionBytes(DummyEntity.createRandomBytes(8)).build();
        cut.addBlockRequest(0, 0, 15, PeerDirection.Upload);
        cut.queueNextPieceForSending();
        cut.queueNextPieceForSending();
        this.verifyAll();
    }

    @Test
    public void testQueueNextPieceForSending() throws Exception {
        Torrent torrentMock = (Torrent)this.createMock(Torrent.class);
        BitTorrentSocket socketMock = (BitTorrentSocket)this.createMock(BitTorrentSocket.class);
        AbstractFileSet fileSetMock = (AbstractFileSet)this.createMock(AbstractFileSet.class);
        Piece pieceMock = (Piece)this.createMock(Piece.class);
        Capture diskJobCapture = EasyMock.newCapture();
        socketMock.enqueueMessage((IMessage)EasyMock.isA(MessageBlock.class));
        torrentMock.addUploadedBytes(15L);
        EasyMock.expect((Object)torrentMock.getFileSet()).andStubReturn((Object)fileSetMock);
        EasyMock.expect((Object)fileSetMock.getBitfieldBytes()).andStubReturn((Object)new byte[1]);
        EasyMock.expect((Object)fileSetMock.getPiece(EasyMock.eq((int)0))).andReturn((Object)pieceMock);
        torrentMock.addDiskJob((IDiskJob)EasyMock.capture((Capture)diskJobCapture));
        EasyMock.expect((Object)pieceMock.getIndex()).andStubReturn((Object)0);
        EasyMock.expect((Object)pieceMock.loadPiece(EasyMock.eq((int)0), EasyMock.eq((int)15))).andReturn((Object)new byte[15]);
        this.replayAll();
        Peer cut = new Peer.Builder().setTorrent(torrentMock).setSocket(socketMock).setId(DummyEntity.createUniquePeerId(new byte[0][])).setExtensionBytes(DummyEntity.createRandomBytes(8)).build();
        cut.addBlockRequest(0, 0, 15, PeerDirection.Upload);
        cut.queueNextPieceForSending();
        ((DiskJobReadBlock)diskJobCapture.getValue()).process();
        this.verifyAll();
    }

    @Test
    public void testDiscardAllBlockRequests() {
        Torrent torrentMock = (Torrent)this.createMock(Torrent.class);
        BitTorrentSocket socketMock = (BitTorrentSocket)this.createMock(BitTorrentSocket.class);
        AbstractFileSet fileSetMock = (AbstractFileSet)this.createMock(AbstractFileSet.class);
        Piece pieceMock = (Piece)this.createMock(Piece.class);
        EasyMock.expect((Object)torrentMock.getFileSet()).andStubReturn((Object)fileSetMock);
        EasyMock.expect((Object)fileSetMock.getBitfieldBytes()).andStubReturn((Object)new byte[1]);
        EasyMock.expect((Object)fileSetMock.getBlockSize()).andStubReturn((Object)15);
        EasyMock.expect((Object)fileSetMock.getPiece(EasyMock.eq((int)0))).andReturn((Object)pieceMock).atLeastOnce();
        pieceMock.setBlockStatus(EasyMock.eq((int)0), (BlockStatus)EasyMock.eq((Object)BlockStatus.Needed));
        pieceMock.setBlockStatus(EasyMock.eq((int)1), (BlockStatus)EasyMock.eq((Object)BlockStatus.Needed));
        socketMock.enqueueMessage((IMessage)EasyMock.isA(MessageRequest.class));
        socketMock.enqueueMessage((IMessage)EasyMock.isA(MessageRequest.class));
        this.replayAll();
        Peer cut = new Peer.Builder().setTorrent(torrentMock).setSocket(socketMock).setId(DummyEntity.createUniquePeerId(new byte[0][])).setExtensionBytes(DummyEntity.createRandomBytes(8)).build();
        cut.addBlockRequest(0, 0, 15, PeerDirection.Download);
        cut.addBlockRequest(0, 15, 15, PeerDirection.Download);
        Assert.assertEquals((String)"Working queue should have two items", (long)2L, (long)cut.getWorkQueueSize(PeerDirection.Download));
        cut.discardAllBlockRequests();
        this.verifyAll();
        Assert.assertEquals((String)"Working queue should have two items", (long)0L, (long)cut.getWorkQueueSize(PeerDirection.Download));
    }

    @Test
    public void testSetHasPiece() {
        Torrent torrentMock = (Torrent)this.createMock(Torrent.class);
        BitTorrentSocket socketMock = (BitTorrentSocket)this.createMock(BitTorrentSocket.class);
        AbstractFileSet fileSetMock = (AbstractFileSet)this.createMock(AbstractFileSet.class);
        EasyMock.expect((Object)torrentMock.getFileSet()).andStubReturn((Object)fileSetMock);
        EasyMock.expect((Object)torrentMock.isDownloadingMetadata()).andStubReturn((Object)false);
        EasyMock.expect((Object)fileSetMock.getBitfieldBytes()).andStubReturn((Object)new byte[1]);
        EasyMock.expect((Object)fileSetMock.getBlockSize()).andStubReturn((Object)15);
        this.replayAll();
        Peer cut = new Peer.Builder().setTorrent(torrentMock).setSocket(socketMock).setId(DummyEntity.createUniquePeerId(new byte[0][])).setExtensionBytes(DummyEntity.createRandomBytes(8)).build();
        Assert.assertFalse((String)"Piece 0 should not be available yet", (boolean)cut.hasPiece(0));
        Assert.assertEquals((String)"No pieces should be completed yet", (long)0L, (long)cut.countHavePieces());
        cut.setHavingPiece(0);
        Assert.assertTrue((String)"Piece 0 should be available", (boolean)cut.hasPiece(0));
        Assert.assertEquals((String)"One pieces should be completed", (long)1L, (long)cut.countHavePieces());
    }

    @Test
    public void testSetGetRequestLimit() {
        Torrent torrentMock = (Torrent)this.createMock(Torrent.class);
        BitTorrentSocket socketMock = (BitTorrentSocket)this.createMock(BitTorrentSocket.class);
        AbstractFileSet fileSetMock = (AbstractFileSet)this.createMock(AbstractFileSet.class);
        EasyMock.expect((Object)torrentMock.getFileSet()).andStubReturn((Object)fileSetMock);
        EasyMock.expect((Object)fileSetMock.getBitfieldBytes()).andStubReturn((Object)new byte[1]);
        this.replayAll();
        Peer cut = new Peer.Builder().setTorrent(torrentMock).setSocket(socketMock).setId(DummyEntity.createUniquePeerId(new byte[0][])).setExtensionBytes(DummyEntity.createRandomBytes(8)).build();
        Assert.assertEquals((String)"Initial request limit should have been 1", (long)1L, (long)cut.getRequestLimit());
        cut.setRequestLimit(7);
        Assert.assertEquals((String)"Request limit should have changed", (long)7L, (long)cut.getRequestLimit());
        cut.setRequestLimit(-1);
        Assert.assertEquals((String)"Request limit should not have changed", (long)7L, (long)cut.getRequestLimit());
        cut.setAbsoluteRequestLimit(5);
        Assert.assertEquals((String)"Request limit should have been limited", (long)5L, (long)cut.getRequestLimit());
        cut.setRequestLimit(7);
        Assert.assertEquals((String)"Request limit should not have changed", (long)5L, (long)cut.getRequestLimit());
    }

    @Test
    public void testGetFreeWorkTime() {
        Torrent torrentMock = (Torrent)this.createMock(Torrent.class);
        BitTorrentSocket socketMock = (BitTorrentSocket)this.createMock(BitTorrentSocket.class);
        AbstractFileSet fileSetMock = (AbstractFileSet)this.createMock(AbstractFileSet.class);
        EasyMock.expect((Object)torrentMock.getFileSet()).andStubReturn((Object)fileSetMock);
        EasyMock.expect((Object)fileSetMock.getBitfieldBytes()).andStubReturn((Object)new byte[1]);
        EasyMock.expect((Object)fileSetMock.getBlockSize()).andStubReturn((Object)15);
        socketMock.enqueueMessage((IMessage)EasyMock.isA(MessageRequest.class));
        this.replayAll();
        Peer cut = new Peer.Builder().setTorrent(torrentMock).setSocket(socketMock).setId(DummyEntity.createUniquePeerId(new byte[0][])).setExtensionBytes(DummyEntity.createRandomBytes(8)).build();
        Assert.assertEquals((String)"Initial free work time incorrect", (long)1L, (long)cut.getFreeWorkTime());
        cut.addBlockRequest(0, 0, 15, PeerDirection.Download);
        Assert.assertEquals((String)"Work time should have been affected by the download job.", (long)0L, (long)cut.getFreeWorkTime());
        cut.setRequestLimit(5);
        Assert.assertEquals((String)"Work time should have been affected by request limit.", (long)4L, (long)cut.getFreeWorkTime());
    }

    @Test
    public void testGettersForFinalFields() {
        Torrent torrentMock = (Torrent)this.createMock(Torrent.class);
        BitTorrentSocket socketMock = (BitTorrentSocket)this.createMock(BitTorrentSocket.class);
        AbstractFileSet fileSetMock = (AbstractFileSet)this.createMock(AbstractFileSet.class);
        EasyMock.expect((Object)torrentMock.getFileSet()).andStubReturn((Object)fileSetMock);
        EasyMock.expect((Object)fileSetMock.getBitfieldBytes()).andStubReturn((Object)new byte[1]);
        this.replayAll();
        Peer cut = new Peer.Builder().setTorrent(torrentMock).setSocket(socketMock).setId(DummyEntity.createUniquePeerId(new byte[0][])).setExtensionBytes(DummyEntity.createRandomBytes(8)).build();
        Assert.assertTrue((String)"Socket reference has changed", (socketMock == cut.getBitTorrentSocket() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Torrent reference has changed", (torrentMock == cut.getTorrent() ? 1 : 0) != 0);
    }

    @Test
    public void testToString() {
        Torrent torrentMock = (Torrent)this.createMock(Torrent.class);
        BitTorrentSocket socketMock = (BitTorrentSocket)this.createMock(BitTorrentSocket.class);
        AbstractFileSet fileSetMock = (AbstractFileSet)this.createMock(AbstractFileSet.class);
        EasyMock.expect((Object)torrentMock.getFileSet()).andStubReturn((Object)fileSetMock);
        EasyMock.expect((Object)fileSetMock.getBitfieldBytes()).andStubReturn((Object)new byte[1]);
        this.replayAll();
        Peer cut = new Peer.Builder().setTorrent(torrentMock).setSocket(socketMock).setId(DummyEntity.createUniquePeerId(new byte[0][])).setExtensionBytes(DummyEntity.createRandomBytes(8)).build();
        Assert.assertTrue((String)"Incorrect toString start", (boolean)cut.toString().startsWith("Peer["));
    }

    @Test
    public void testHasExtensionIllegalIndexOutOfBounds() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("index");
        Torrent torrentMock = (Torrent)this.createMock(Torrent.class);
        BitTorrentSocket socketMock = (BitTorrentSocket)this.createMock(BitTorrentSocket.class);
        AbstractFileSet fileSetMock = (AbstractFileSet)this.createMock(AbstractFileSet.class);
        EasyMock.expect((Object)torrentMock.getFileSet()).andStubReturn((Object)fileSetMock);
        EasyMock.expect((Object)fileSetMock.getBitfieldBytes()).andStubReturn((Object)new byte[1]);
        this.replayAll();
        Peer cut = new Peer.Builder().setTorrent(torrentMock).setSocket(socketMock).setId(DummyEntity.createUniquePeerId(new byte[0][])).setExtensionBytes(new byte[]{1, 2, 0, 0, 0, 0, 0, 0}).build();
        cut.hasExtension(8, 0);
    }

    @Test
    public void testCheckDisconnect() {
        Torrent torrentMock = (Torrent)this.createMock(Torrent.class);
        BitTorrentSocket socketMock = (BitTorrentSocket)this.createMock(BitTorrentSocket.class);
        AbstractFileSet fileSetMock = (AbstractFileSet)this.createMock(AbstractFileSet.class);
        EasyMock.expect((Object)torrentMock.getFileSet()).andStubReturn((Object)fileSetMock);
        EasyMock.expect((Object)fileSetMock.getBitfieldBytes()).andStubReturn((Object)new byte[1]);
        EasyMock.expect((Object)socketMock.getLastActivity()).andAnswer(() -> LocalDateTime.now().minus(40L, ChronoUnit.SECONDS));
        socketMock.enqueueMessage((IMessage)EasyMock.isA(MessageKeepAlive.class));
        this.replayAll();
        Peer cut = new Peer.Builder().setTorrent(torrentMock).setSocket(socketMock).setId(DummyEntity.createUniquePeerId(new byte[0][])).setExtensionBytes(DummyEntity.createRandomBytes(8)).build();
        cut.checkDisconnect();
        this.verifyAll();
    }

    @Test
    public void testOnTorrentPhaseChange() {
        Torrent torrentMock = (Torrent)this.createMock(Torrent.class);
        BitTorrentSocket socketMock = (BitTorrentSocket)this.createMock(BitTorrentSocket.class);
        AbstractFileSet fileSetMock = (AbstractFileSet)this.createMock(AbstractFileSet.class);
        EasyMock.expect((Object)torrentMock.getFileSet()).andStubReturn((Object)fileSetMock);
        EasyMock.expect((Object)fileSetMock.getBitfieldBytes()).andReturn((Object)new byte[1]).times(2);
        EasyMock.expect((Object)torrentMock.isDownloadingMetadata()).andReturn((Object)false);
        this.replayAll();
        Peer cut = new Peer.Builder().setTorrent(torrentMock).setSocket(socketMock).setId(DummyEntity.createUniquePeerId(new byte[0][])).setExtensionBytes(DummyEntity.createRandomBytes(8)).build();
        cut.onTorrentPhaseChange();
        this.verifyAll();
    }

    @Test
    public void testOnTorrentPhaseChangeDownloadingMetadata() {
        Torrent torrentMock = (Torrent)this.createMock(Torrent.class);
        BitTorrentSocket socketMock = (BitTorrentSocket)this.createMock(BitTorrentSocket.class);
        AbstractFileSet fileSetMock = (AbstractFileSet)this.createMock(AbstractFileSet.class);
        EasyMock.expect((Object)torrentMock.getFileSet()).andStubReturn((Object)fileSetMock);
        EasyMock.expect((Object)fileSetMock.getBitfieldBytes()).andStubReturn((Object)new byte[1]);
        EasyMock.expect((Object)torrentMock.isDownloadingMetadata()).andReturn((Object)true);
        this.replayAll();
        Peer cut = new Peer.Builder().setTorrent(torrentMock).setSocket(socketMock).setId(DummyEntity.createUniquePeerId(new byte[0][])).setExtensionBytes(DummyEntity.createRandomBytes(8)).build();
        cut.onTorrentPhaseChange();
        this.verifyAll();
    }

    @Test
    public void testGetLastActivity() {
        Torrent torrentMock = (Torrent)this.createMock(Torrent.class);
        BitTorrentSocket socketMock = (BitTorrentSocket)this.createMock(BitTorrentSocket.class);
        AbstractFileSet fileSetMock = (AbstractFileSet)this.createMock(AbstractFileSet.class);
        EasyMock.expect((Object)torrentMock.getFileSet()).andStubReturn((Object)fileSetMock);
        EasyMock.expect((Object)fileSetMock.getBitfieldBytes()).andStubReturn((Object)new byte[1]);
        LocalDateTime time = LocalDateTime.now();
        EasyMock.expect((Object)socketMock.getLastActivity()).andReturn((Object)time);
        this.replayAll();
        Peer cut = new Peer.Builder().setTorrent(torrentMock).setSocket(socketMock).setId(DummyEntity.createUniquePeerId(new byte[0][])).setExtensionBytes(DummyEntity.createRandomBytes(8)).build();
        Assert.assertEquals((String)"Incorrect date returned", (Object)time, (Object)cut.getLastActivity());
        this.verifyAll();
    }

    @Test
    public void testCheckDisconnectIdle() {
        Torrent torrentMock = (Torrent)this.createMock(Torrent.class);
        BitTorrentSocket socketMock = (BitTorrentSocket)this.createMock(BitTorrentSocket.class);
        AbstractFileSet fileSetMock = (AbstractFileSet)this.createMock(AbstractFileSet.class);
        EasyMock.expect((Object)torrentMock.getFileSet()).andStubReturn((Object)fileSetMock);
        EasyMock.expect((Object)fileSetMock.getBitfieldBytes()).andStubReturn((Object)new byte[1]);
        EasyMock.expect((Object)socketMock.getLastActivity()).andAnswer(() -> LocalDateTime.now().minus(10L, ChronoUnit.SECONDS));
        this.replayAll();
        Peer cut = new Peer.Builder().setTorrent(torrentMock).setSocket(socketMock).setId(DummyEntity.createUniquePeerId(new byte[0][])).setExtensionBytes(DummyEntity.createRandomBytes(8)).build();
        cut.checkDisconnect();
        this.verifyAll();
    }

    @Test
    public void testCheckDisconnectFiveStrikes() {
        Torrent torrentMock = (Torrent)this.createMock(Torrent.class);
        BitTorrentSocket socketMock = (BitTorrentSocket)this.createMock(BitTorrentSocket.class);
        AbstractFileSet fileSetMock = (AbstractFileSet)this.createMock(AbstractFileSet.class);
        EasyMock.expect((Object)torrentMock.getFileSet()).andStubReturn((Object)fileSetMock);
        EasyMock.expect((Object)fileSetMock.getBitfieldBytes()).andStubReturn((Object)new byte[1]);
        socketMock.close();
        this.replayAll();
        Peer cut = new Peer.Builder().setTorrent(torrentMock).setSocket(socketMock).setId(DummyEntity.createUniquePeerId(new byte[0][])).setExtensionBytes(DummyEntity.createRandomBytes(8)).build();
        cut.addStrike(5);
        cut.checkDisconnect();
        this.verifyAll();
    }

    @Test
    public void testHasExtensionIllegalIndexBelowZero() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("index");
        Torrent torrentMock = (Torrent)this.createMock(Torrent.class);
        BitTorrentSocket socketMock = (BitTorrentSocket)this.createMock(BitTorrentSocket.class);
        AbstractFileSet fileSetMock = (AbstractFileSet)this.createMock(AbstractFileSet.class);
        EasyMock.expect((Object)torrentMock.getFileSet()).andStubReturn((Object)fileSetMock);
        EasyMock.expect((Object)fileSetMock.getBitfieldBytes()).andStubReturn((Object)new byte[1]);
        this.replayAll();
        Peer cut = new Peer.Builder().setTorrent(torrentMock).setSocket(socketMock).setId(DummyEntity.createUniquePeerId(new byte[0][])).setExtensionBytes(new byte[]{1, 2, 0, 0, 0, 0, 0, 0}).build();
        cut.hasExtension(-1, 0);
    }

    @Test
    public void testHasExtension() {
        Torrent torrentMock = (Torrent)this.createMock(Torrent.class);
        BitTorrentSocket socketMock = (BitTorrentSocket)this.createMock(BitTorrentSocket.class);
        AbstractFileSet fileSetMock = (AbstractFileSet)this.createMock(AbstractFileSet.class);
        EasyMock.expect((Object)torrentMock.getFileSet()).andStubReturn((Object)fileSetMock);
        EasyMock.expect((Object)fileSetMock.getBitfieldBytes()).andStubReturn((Object)new byte[1]);
        this.replayAll();
        Peer cut = new Peer.Builder().setTorrent(torrentMock).setSocket(socketMock).setId(DummyEntity.createUniquePeerId(new byte[0][])).setExtensionBytes(new byte[]{1, 2, 0, 0, 0, 0, 0, 0}).build();
        Assert.assertFalse((String)"Extension should not have reported true", (boolean)cut.hasExtension(0, 0));
        Assert.assertTrue((String)"Extension should have reported true", (boolean)cut.hasExtension(0, 1));
        Assert.assertTrue((String)"Extension should have reported true", (boolean)cut.hasExtension(1, 2));
    }

    @Test
    public void testSetGetClientName() {
        Torrent torrentMock = (Torrent)this.createMock(Torrent.class);
        BitTorrentSocket socketMock = (BitTorrentSocket)this.createMock(BitTorrentSocket.class);
        AbstractFileSet fileSetMock = (AbstractFileSet)this.createMock(AbstractFileSet.class);
        EasyMock.expect((Object)torrentMock.getFileSet()).andStubReturn((Object)fileSetMock);
        EasyMock.expect((Object)fileSetMock.getBitfieldBytes()).andStubReturn((Object)new byte[1]);
        this.replayAll();
        Peer cut = new Peer.Builder().setTorrent(torrentMock).setSocket(socketMock).setId(DummyEntity.createUniquePeerId(new byte[0][])).setExtensionBytes(DummyEntity.createRandomBytes(8)).build();
        Assert.assertNotNull((String)"Client name should be set based on peer ID during construction", (Object)cut.getClientName());
        String clientName = "JavaTorrent 0.6.0";
        cut.setClientName("JavaTorrent 0.6.0");
        Assert.assertEquals((String)"Client name should have equalled the value set", (Object)"JavaTorrent 0.6.0", (Object)cut.getClientName());
    }
}

