/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import org.johnnei.javatorrent.Version;
import org.johnnei.javatorrent.async.LoopingRunnable;
import org.johnnei.javatorrent.bittorrent.protocol.MessageFactory;
import org.johnnei.javatorrent.bittorrent.protocol.messages.IMessage;
import org.johnnei.javatorrent.bittorrent.tracker.ITracker;
import org.johnnei.javatorrent.bittorrent.tracker.TrackerException;
import org.johnnei.javatorrent.bittorrent.tracker.TrackerFactory;
import org.johnnei.javatorrent.disk.IDiskJob;
import org.johnnei.javatorrent.internal.disk.IOManager;
import org.johnnei.javatorrent.internal.torrent.TorrentManager;
import org.johnnei.javatorrent.internal.tracker.TrackerManager;
import org.johnnei.javatorrent.module.IModule;
import org.johnnei.javatorrent.network.ConnectionDegradation;
import org.johnnei.javatorrent.phases.PhaseRegulator;
import org.johnnei.javatorrent.torrent.Torrent;
import org.johnnei.javatorrent.tracker.IPeerConnector;
import org.johnnei.javatorrent.tracker.IPeerDistributor;
import org.johnnei.javatorrent.utils.Argument;
import org.johnnei.javatorrent.utils.CheckedBiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TorrentClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(TorrentClient.class);
    private ConnectionDegradation connectionDegradation;
    private MessageFactory messageFactory;
    private TorrentManager torrentManager;
    private TrackerManager trackerManager;
    private PhaseRegulator phaseRegulator;
    private IPeerConnector peerConnector;
    private IPeerDistributor peerDistributor;
    private ScheduledExecutorService executorService;
    private IOManager ioManager;
    private LoopingRunnable ioManagerRunner;
    private int downloadPort;
    private final byte[] extensionBytes;
    private final byte[] peerId;
    private AtomicInteger transactionId;
    private Collection<IModule> modules;

    private TorrentClient(Builder builder) {
        this.peerDistributor = (IPeerDistributor)Objects.requireNonNull(builder.peerDistributor.apply(this), "Peer distributor is invalid.");
        this.connectionDegradation = Objects.requireNonNull(builder.connectionDegradation, "Connection degradation is required to setup connections with peers.");
        LOGGER.info(String.format("Configured connection types: %s", this.connectionDegradation));
        this.messageFactory = builder.messageFactoryBuilder.build();
        this.phaseRegulator = Objects.requireNonNull(builder.phaseRegulator, "Phase regulator is required to regulate the download/seed phases of a torrent.");
        LOGGER.info(String.format("Configured phases: %s", this.phaseRegulator));
        this.executorService = Objects.requireNonNull(builder.executorService, "Executor service is required to process torrent tasks.");
        this.peerConnector = (IPeerConnector)Objects.requireNonNull(builder.peerConnector, "Peer connector required to allow external connections").apply(this);
        LOGGER.info(String.format("Configured %s as Peer Connector", this.peerConnector));
        Objects.requireNonNull(builder.trackerFactoryBuilder, "At least one tracker protocol must be configured.");
        TrackerFactory trackerFactory = builder.trackerFactoryBuilder.setTorrentClient(this).build();
        this.trackerManager = new TrackerManager(this.peerConnector, trackerFactory);
        this.torrentManager = new TorrentManager(this.trackerManager);
        LOGGER.info(String.format("Configured trackers: %s", trackerFactory));
        this.modules = builder.modules;
        LOGGER.info(String.format("Configured modules: %s", this.modules.stream().map(m -> String.format("%s (BEP %d)", m.getClass().getSimpleName(), m.getRelatedBep())).reduce((a, b) -> a + ", " + b).orElse("")));
        this.downloadPort = builder.downloadPort;
        this.extensionBytes = builder.extensionBytes;
        this.peerId = this.createPeerId();
        this.transactionId = new AtomicInteger(new Random().nextInt());
        this.ioManager = new IOManager();
        this.ioManagerRunner = new LoopingRunnable(this.ioManager);
        Thread ioManagerThread = new Thread((Runnable)this.ioManagerRunner, "Disk Manager");
        ioManagerThread.setDaemon(true);
        ioManagerThread.start();
        this.torrentManager.start(this);
        if (builder.acceptIncomingConnections) {
            this.torrentManager.enableConnectionAcceptor();
        }
        this.peerConnector.start();
    }

    private byte[] createPeerId() {
        char[] version = String.format("%s%2s%s", Version.VERSION_MAJOR, Version.VERSION_MINOR, Version.VERSION_PATCH).replace(" ", "0").toCharArray();
        byte[] newPeerId = new byte[20];
        newPeerId[0] = 45;
        newPeerId[1] = 74;
        newPeerId[2] = 84;
        newPeerId[3] = (byte)version[0];
        newPeerId[4] = (byte)version[1];
        newPeerId[5] = (byte)version[2];
        newPeerId[6] = (byte)version[3];
        newPeerId[7] = 45;
        Random random = new Random();
        for (int i = 8; i < newPeerId.length; ++i) {
            newPeerId[i] = (byte)(random.nextInt() & 0xFF);
        }
        return newPeerId;
    }

    public void download(Torrent torrent, Collection<String> trackerUrls) {
        trackerUrls.forEach(url -> this.trackerManager.addTorrent(torrent, (String)url));
        this.download(torrent);
    }

    public void download(Torrent torrent) {
        this.torrentManager.addTorrent(torrent);
    }

    public void shutdown() {
        this.torrentManager.stop();
        this.ioManagerRunner.stop();
        this.executorService.shutdown();
        this.peerConnector.stop();
        this.modules.stream().forEach(IModule::onShutdown);
    }

    public int createUniqueTransactionId() {
        return this.transactionId.incrementAndGet();
    }

    public void addDiskJob(IDiskJob task) {
        this.ioManager.addTask(task);
    }

    public int getConnectingCountFor(Torrent torrent) {
        return this.trackerManager.getConnectingCountFor(torrent);
    }

    public List<ITracker> getTrackersFor(Torrent torrent) {
        return this.trackerManager.getTrackersFor(torrent);
    }

    public MessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    public ConnectionDegradation getConnectionDegradation() {
        return this.connectionDegradation;
    }

    public PhaseRegulator getPhaseRegulator() {
        return this.phaseRegulator;
    }

    public ScheduledExecutorService getExecutorService() {
        return this.executorService;
    }

    public IPeerConnector getPeerConnector() {
        return this.peerConnector;
    }

    public int getDownloadPort() {
        return this.downloadPort;
    }

    public byte[] getExtensionBytes() {
        return Arrays.copyOf(this.extensionBytes, this.extensionBytes.length);
    }

    public byte[] getPeerId() {
        return this.peerId;
    }

    public <T extends IModule> Optional<T> getModule(Class<T> type) {
        return this.modules.stream().filter(m -> m.getClass().equals(type)).findAny();
    }

    public Collection<IModule> getModules() {
        return Collections.unmodifiableCollection(this.modules);
    }

    public Optional<Torrent> getTorrentByHash(byte[] torrentHash) {
        return this.torrentManager.getTorrent(torrentHash);
    }

    public IPeerDistributor getPeerDistributor() {
        return this.peerDistributor;
    }

    public int getTorrentCount() {
        return this.torrentManager.getTorrents().size();
    }

    public static class Builder {
        private final MessageFactory.Builder messageFactoryBuilder = new MessageFactory.Builder();
        private final Collection<IModule> modules;
        private ConnectionDegradation connectionDegradation;
        private PhaseRegulator phaseRegulator;
        private TrackerFactory.Builder trackerFactoryBuilder = new TrackerFactory.Builder();
        private Function<TorrentClient, IPeerConnector> peerConnector;
        private Function<TorrentClient, IPeerDistributor> peerDistributor;
        private ScheduledExecutorService executorService;
        private boolean acceptIncomingConnections;
        private int downloadPort;
        private byte[] extensionBytes;

        public Builder() {
            this.modules = new ArrayList<IModule>();
            this.extensionBytes = new byte[8];
        }

        public Builder registerModule(IModule module) {
            for (Class<IModule> dependingModule : module.getDependsOn()) {
                if (this.modules.stream().anyMatch(m -> m.getClass().equals(dependingModule))) continue;
                throw new IllegalStateException(String.format("Depending module %s is missing.", dependingModule.getSimpleName()));
            }
            module.configureTorrentClient(this);
            this.modules.add(module);
            return this;
        }

        public Builder enableExtensionBit(int bit) {
            int index = this.extensionBytes.length - 1 - bit / 8;
            int bitValue = 1 << Math.floorMod(bit, 8);
            int n = index;
            this.extensionBytes[n] = (byte)(this.extensionBytes[n] | bitValue);
            return this;
        }

        public Builder acceptIncomingConnections(boolean acceptIncomingConnections) {
            this.acceptIncomingConnections = acceptIncomingConnections;
            return this;
        }

        public Builder registerMessage(int id, Supplier<IMessage> messageSupplier) {
            this.messageFactoryBuilder.registerMessage(id, messageSupplier);
            return this;
        }

        public Builder registerTrackerProtocol(String protocol, CheckedBiFunction<String, TorrentClient, ITracker, TrackerException> supplier) {
            this.trackerFactoryBuilder.registerProtocol(protocol, supplier);
            return this;
        }

        public Builder setPhaseRegulator(PhaseRegulator phaseRegulator) {
            this.phaseRegulator = phaseRegulator;
            return this;
        }

        public Builder setConnectionDegradation(ConnectionDegradation connectionDegradation) {
            this.connectionDegradation = connectionDegradation;
            return this;
        }

        public Builder setPeerConnector(Function<TorrentClient, IPeerConnector> peerConnector) {
            this.peerConnector = peerConnector;
            return this;
        }

        public Builder setExecutorService(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public Builder setDownloadPort(int downloadPort) {
            this.downloadPort = downloadPort;
            return this;
        }

        public Builder setPeerDistributor(Function<TorrentClient, IPeerDistributor> peerDistributor) {
            Argument.requireNonNull(peerDistributor, "Peer distributors cannot be null");
            this.peerDistributor = peerDistributor;
            return this;
        }

        public TorrentClient build() throws Exception {
            TorrentClient client = new TorrentClient(this);
            for (IModule module : this.modules) {
                module.onBuild(client);
            }
            return client;
        }
    }
}

