/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.bittorrent.encoding;

import java.math.BigInteger;
import java.util.Objects;
import org.johnnei.javatorrent.bittorrent.encoding.AbstractBencodedValue;

public class BencodedInteger
extends AbstractBencodedValue {
    private static final BigInteger MAX_LONG_VALUE = BigInteger.valueOf(Long.MAX_VALUE);
    private static final BigInteger MIN_LONG_VALUE = BigInteger.valueOf(Long.MIN_VALUE);
    private BigInteger bigInteger;

    public BencodedInteger(long integerValue) {
        this(BigInteger.valueOf(integerValue));
    }

    public BencodedInteger(BigInteger bigInteger) {
        this.bigInteger = bigInteger;
    }

    @Override
    public long asLong() {
        if (this.bigInteger.compareTo(MAX_LONG_VALUE) > 0 || this.bigInteger.compareTo(MIN_LONG_VALUE) < 0) {
            throw new UnsupportedOperationException("Integer value is out of range to fit in a long.");
        }
        return this.bigInteger.longValueExact();
    }

    @Override
    public BigInteger asBigInteger() {
        return this.bigInteger;
    }

    @Override
    public String serialize() {
        return String.format("i%se", this.bigInteger.toString());
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof BencodedInteger)) {
            return false;
        }
        BencodedInteger integer = (BencodedInteger)o;
        return Objects.equals(this.bigInteger, integer.bigInteger);
    }

    public int hashCode() {
        return Objects.hash(this.bigInteger);
    }

    public String toString() {
        return String.format("BencodedInteger[value=%s]", this.bigInteger);
    }
}

