/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.bittorrent.encoding;

import java.nio.charset.Charset;
import java.util.Arrays;
import org.johnnei.javatorrent.bittorrent.encoding.AbstractBencodedValue;

public class BencodedString
extends AbstractBencodedValue {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private byte[] value;

    public BencodedString(String value) {
        this.value = value.getBytes(UTF8);
    }

    public BencodedString(byte[] value) {
        this.value = value;
    }

    @Override
    public String asString() {
        return new String(this.value, UTF8);
    }

    @Override
    public byte[] asBytes() {
        return Arrays.copyOf(this.value, this.value.length);
    }

    @Override
    public String serialize() {
        return String.format("%d:%s", this.value.length, this.asString());
    }

    public String toString() {
        return String.format("BencodedString[value=%s]", this.asString());
    }
}

