/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.bittorrent.protocol.messages;

import java.util.Arrays;
import org.johnnei.javatorrent.bittorrent.protocol.messages.IMessage;
import org.johnnei.javatorrent.network.InStream;
import org.johnnei.javatorrent.network.OutStream;
import org.johnnei.javatorrent.torrent.peer.Peer;

public class MessageBitfield
implements IMessage {
    private byte[] bitfield;

    public MessageBitfield() {
        this.bitfield = new byte[0];
    }

    public MessageBitfield(byte[] bitfield) {
        this.bitfield = bitfield;
    }

    @Override
    public void write(OutStream outStream) {
        for (int i = 0; i < this.bitfield.length; ++i) {
            outStream.writeByte(this.bitfield[i]);
        }
    }

    @Override
    public void read(InStream inStream) {
        this.bitfield = new byte[inStream.available()];
        for (int i = 0; i < this.bitfield.length; ++i) {
            this.bitfield[i] = inStream.readByte();
        }
    }

    @Override
    public void process(Peer peer) {
        int pieceIndex = 0;
        for (byte b : this.bitfield) {
            for (int i = 0; i < 8; ++i) {
                boolean isSet;
                boolean bl = isSet = (b >> 7 - i & 1) != 0;
                if (isSet) {
                    peer.setHavingPiece(pieceIndex);
                }
                ++pieceIndex;
            }
        }
    }

    @Override
    public int getLength() {
        return 1 + this.bitfield.length;
    }

    @Override
    public int getId() {
        return 5;
    }

    public String toString() {
        return String.format("MessageBitfield[bitfield=%s]", Arrays.toString(this.bitfield));
    }
}

