/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.bittorrent.tracker;

import java.time.Clock;
import java.time.Duration;
import java.time.LocalDateTime;
import org.johnnei.javatorrent.bittorrent.tracker.TrackerEvent;
import org.johnnei.javatorrent.torrent.Torrent;

public class TorrentInfo {
    private Clock clock;
    private Torrent torrent;
    private LocalDateTime lastAnnounceTime;
    private int seeders;
    private int leechers;
    private int downloaded;
    private TrackerEvent event;

    public TorrentInfo(Torrent torrent, Clock clock) {
        this.torrent = torrent;
        this.clock = clock;
        this.event = TrackerEvent.EVENT_STARTED;
        this.lastAnnounceTime = LocalDateTime.now(clock).minus(Duration.ofSeconds(30L));
    }

    public void setEvent(TrackerEvent event) {
        this.event = event;
    }

    public void setInfo(int seeders, int leechers) {
        this.lastAnnounceTime = LocalDateTime.now(this.clock);
        this.seeders = seeders;
        this.leechers = leechers;
    }

    public void setInfo(int seeders, int leechers, int downloadCount) {
        this.seeders = seeders;
        this.leechers = leechers;
        this.downloaded = downloadCount;
    }

    public TrackerEvent getEvent() {
        return this.event;
    }

    public int getSeeders() {
        return this.seeders;
    }

    public int getLeechers() {
        return this.leechers;
    }

    public String getDownloadCount() {
        return this.downloaded == 0 ? "N/A" : Integer.toString(this.downloaded);
    }

    public Duration getTimeSinceLastAnnounce() {
        return Duration.between(this.lastAnnounceTime, LocalDateTime.now(this.clock));
    }

    public Torrent getTorrent() {
        return this.torrent;
    }
}

