/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.disk;

import java.io.IOException;
import java.util.function.Consumer;
import org.johnnei.javatorrent.disk.IDiskJob;
import org.johnnei.javatorrent.internal.disk.DiskJobPriority;
import org.johnnei.javatorrent.torrent.files.Piece;

public class DiskJobWriteBlock
implements IDiskJob {
    private final Consumer<DiskJobWriteBlock> callback;
    private final Piece piece;
    private final int blockIndex;
    private final byte[] data;

    public DiskJobWriteBlock(Piece piece, int blockIndex, byte[] data, Consumer<DiskJobWriteBlock> callback) {
        this.callback = callback;
        this.piece = piece;
        this.blockIndex = blockIndex;
        this.data = data;
    }

    @Override
    public void process() throws IOException {
        this.piece.storeBlock(this.blockIndex, this.data);
        this.callback.accept(this);
    }

    public Piece getPiece() {
        return this.piece;
    }

    public int getBlockIndex() {
        return this.blockIndex;
    }

    @Override
    public int getPriority() {
        return DiskJobPriority.RECEIVED_DATA.getPriority();
    }
}

