/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.internal.network.socket;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Objects;
import org.johnnei.javatorrent.internal.network.socket.ISocket;

public class TcpSocket
implements ISocket {
    private Socket socket;

    public TcpSocket() {
        this.socket = new Socket();
    }

    public TcpSocket(Socket socket) {
        this.socket = socket;
    }

    @Override
    public void connect(InetSocketAddress endpoint) throws IOException {
        this.socket.connect(endpoint, 10000);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }

    @Override
    public void close() throws IOException {
        this.socket.close();
    }

    @Override
    public boolean isClosed() {
        return this.socket.isClosed() || !this.socket.isConnected();
    }

    @Override
    public boolean isInputShutdown() {
        return this.socket.isInputShutdown();
    }

    @Override
    public boolean isOutputShutdown() {
        return this.socket.isOutputShutdown();
    }

    public String toString() {
        return String.format("TcpSocket[remoteAddress=%s]", this.socket.getRemoteSocketAddress().toString().substring(1));
    }

    @Override
    public void flush() throws IOException {
        this.socket.getOutputStream().flush();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof TcpSocket)) {
            return false;
        }
        TcpSocket other = (TcpSocket)o;
        return Objects.equals(this.socket, other.socket);
    }

    public int hashCode() {
        return Objects.hash(this.socket);
    }
}

