/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.internal.torrent.peer;

import java.util.Collections;
import java.util.LinkedList;
import java.util.Queue;
import org.johnnei.javatorrent.internal.torrent.peer.Job;

public class Client {
    private final Object queueLock = new Object();
    private boolean isChoked = true;
    private boolean isInterested = false;
    private Queue<Job> workingQueue = new LinkedList<Job>();

    public void choke() {
        this.isChoked = true;
    }

    public void unchoke() {
        this.isChoked = false;
    }

    public void interested() {
        this.isInterested = true;
    }

    public void uninterested() {
        this.isInterested = false;
    }

    public boolean isChoked() {
        return this.isChoked;
    }

    public boolean isInterested() {
        return this.isInterested;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Job popNextJob() {
        Object object = this.queueLock;
        synchronized (object) {
            return this.workingQueue.poll();
        }
    }

    public Iterable<Job> getJobs() {
        return Collections.unmodifiableCollection(this.workingQueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJob(Job job) {
        Object object = this.queueLock;
        synchronized (object) {
            this.workingQueue.remove(job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJob(Job job) {
        Object object = this.queueLock;
        synchronized (object) {
            this.workingQueue.add(job);
        }
    }

    public int getQueueSize() {
        return this.workingQueue.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearJobs() {
        Object object = this.queueLock;
        synchronized (object) {
            this.workingQueue.clear();
        }
    }
}

