/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.internal.tracker;

import java.util.List;
import java.util.Optional;
import org.johnnei.javatorrent.bittorrent.tracker.ITracker;
import org.johnnei.javatorrent.bittorrent.tracker.TrackerFactory;
import org.johnnei.javatorrent.torrent.Torrent;
import org.johnnei.javatorrent.tracker.IPeerConnector;

public class TrackerManager {
    private final TrackerFactory trackerFactory;
    private IPeerConnector peerConnector;

    public TrackerManager(IPeerConnector peerConnector, TrackerFactory trackerFactory) {
        this.trackerFactory = trackerFactory;
        this.peerConnector = peerConnector;
    }

    public void announce(Torrent torrent) {
        this.getTrackersFor(torrent).forEach(tracker -> tracker.announce(torrent));
    }

    public void addTorrent(Torrent torrent, String trackerUrl) {
        Optional<ITracker> tracker = this.getTrackerFor(trackerUrl);
        if (!tracker.isPresent()) {
            return;
        }
        tracker.get().addTorrent(torrent);
    }

    private Optional<ITracker> getTrackerFor(String trackerUrl) {
        return this.trackerFactory.getTrackerFor(trackerUrl);
    }

    public int getConnectingCountFor(Torrent torrent) {
        return this.peerConnector.getConnectingCountFor(torrent);
    }

    public List<ITracker> getTrackersFor(Torrent torrent) {
        return this.trackerFactory.getTrackersHavingTorrent(torrent);
    }
}

