/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.network;

import java.io.IOException;
import java.util.Optional;
import org.johnnei.javatorrent.TorrentClient;
import org.johnnei.javatorrent.bittorrent.protocol.BitTorrentHandshake;
import org.johnnei.javatorrent.internal.network.socket.ISocket;
import org.johnnei.javatorrent.network.BitTorrentSocket;
import org.johnnei.javatorrent.torrent.Torrent;
import org.johnnei.javatorrent.torrent.peer.Peer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPeerConnectionAcceptor
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPeerConnectionAcceptor.class);
    protected final TorrentClient torrentClient;

    public AbstractPeerConnectionAcceptor(TorrentClient torrentClient) {
        this.torrentClient = torrentClient;
    }

    @Override
    public void run() {
        ISocket socket = null;
        try {
            socket = this.acceptSocket();
            this.acceptConnection(this.createSocket(socket));
        }
        catch (IOException e) {
            LOGGER.debug("Failed to create connection with peer.", (Throwable)e);
            this.closeQuietly(socket);
        }
    }

    protected abstract ISocket acceptSocket() throws IOException;

    private void acceptConnection(BitTorrentSocket peerSocket) throws IOException {
        BitTorrentHandshake handshake = peerSocket.readHandshake();
        Optional<Torrent> torrent = this.torrentClient.getTorrentByHash(handshake.getTorrentHash());
        if (!torrent.isPresent()) {
            peerSocket.close();
            return;
        }
        Peer peer = this.createPeer(peerSocket, torrent.get(), handshake.getPeerExtensionBytes(), handshake.getPeerId());
        peerSocket.sendHandshake(this.torrentClient.getExtensionBytes(), this.torrentClient.getPeerId(), torrent.get().getHashArray());
        LOGGER.debug("Accepted connection from {}", (Object)peerSocket);
        torrent.get().addPeer(peer);
    }

    BitTorrentSocket createSocket(ISocket socket) throws IOException {
        return new BitTorrentSocket(this.torrentClient.getMessageFactory(), socket);
    }

    Peer createPeer(BitTorrentSocket socket, Torrent torrent, byte[] extensionBytes, byte[] peerId) {
        return new Peer.Builder().setSocket(socket).setTorrent(torrent).setExtensionBytes(extensionBytes).setId(peerId).build();
    }

    private void closeQuietly(ISocket socket) {
        if (socket == null) {
            return;
        }
        try {
            socket.close();
        }
        catch (IOException e) {
            LOGGER.debug("Failed to close socket", (Throwable)e);
        }
    }
}

