/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.network;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.time.Clock;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import org.johnnei.javatorrent.bittorrent.protocol.BitTorrentHandshake;
import org.johnnei.javatorrent.bittorrent.protocol.MessageFactory;
import org.johnnei.javatorrent.bittorrent.protocol.messages.IMessage;
import org.johnnei.javatorrent.bittorrent.protocol.messages.MessageBlock;
import org.johnnei.javatorrent.bittorrent.protocol.messages.MessageKeepAlive;
import org.johnnei.javatorrent.internal.network.ByteInputStream;
import org.johnnei.javatorrent.internal.network.ByteOutputStream;
import org.johnnei.javatorrent.internal.network.socket.ISocket;
import org.johnnei.javatorrent.network.BitTorrentSocketException;
import org.johnnei.javatorrent.network.ConnectionDegradation;
import org.johnnei.javatorrent.network.InStream;
import org.johnnei.javatorrent.network.OutStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitTorrentSocket {
    private static final Logger LOGGER = LoggerFactory.getLogger(BitTorrentSocket.class);
    private final Object queueLock = new Object();
    private final Object blockQueueLock = new Object();
    private Clock clock = Clock.systemDefaultZone();
    private static final int HANDSHAKE_SIZE = 68;
    private ISocket socket;
    private ByteInputStream inStream;
    private ByteOutputStream outStream;
    private final MessageFactory messageFactory;
    private int downloadRate;
    private int uploadRate;
    private boolean passedHandshake;
    private Queue<IMessage> messageQueue;
    private Queue<IMessage> blockQueue;
    private OutStream buffer;
    private int bufferSize;
    private LocalDateTime lastBufferCreate;
    private LocalDateTime lastActivity;

    public BitTorrentSocket(MessageFactory messageFactory) {
        this.messageFactory = messageFactory;
        this.messageQueue = new LinkedList<IMessage>();
        this.blockQueue = new LinkedList<IMessage>();
        this.lastActivity = LocalDateTime.now(this.clock);
    }

    public BitTorrentSocket(MessageFactory messageFactory, ISocket socket) throws IOException {
        this(messageFactory);
        this.socket = Objects.requireNonNull(socket, "Socket cannot be null, use other constructor instead.");
        this.createIOStreams();
    }

    public void connect(ConnectionDegradation degradation, InetSocketAddress address) throws IOException {
        if (this.socket != null) {
            return;
        }
        BitTorrentSocketException exception = new BitTorrentSocketException("Failed to connect to end point.");
        this.socket = degradation.createPreferredSocket();
        while (this.socket.isClosed()) {
            try {
                this.socket.connect(address);
                this.createIOStreams();
            }
            catch (IOException e) {
                exception.addConnectionFailure(this.socket, e);
                Optional<ISocket> fallbackSocket = degradation.degradeSocket(this.socket);
                if (fallbackSocket.isPresent()) {
                    this.socket = fallbackSocket.get();
                    continue;
                }
                throw exception;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueMessage(IMessage message) {
        if (message instanceof MessageBlock) {
            Object object = this.blockQueueLock;
            synchronized (object) {
                this.blockQueue.add(message);
            }
        }
        Object object = this.queueLock;
        synchronized (object) {
            this.messageQueue.add(message);
        }
    }

    private void createIOStreams() throws IOException {
        this.inStream = new ByteInputStream(new BufferedInputStream(this.socket.getInputStream()));
        this.outStream = new ByteOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
    }

    public IMessage readMessage() {
        InStream stream = this.getBufferedMessage();
        int length = stream.readInt();
        if (length == 0) {
            return new MessageKeepAlive();
        }
        byte id = stream.readByte();
        IMessage message = this.messageFactory.createById(id);
        message.read(stream);
        LOGGER.trace("Read message: {}", (Object)message);
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage() throws IOException {
        Object object;
        IMessage message = null;
        if (!this.messageQueue.isEmpty()) {
            object = this.queueLock;
            synchronized (object) {
                message = this.messageQueue.poll();
            }
        }
        if (!this.blockQueue.isEmpty()) {
            object = this.blockQueueLock;
            synchronized (object) {
                message = this.blockQueue.poll();
            }
        }
        if (message == null) {
            return;
        }
        LOGGER.trace("Writing message {}", message);
        OutStream outBuffer = new OutStream(message.getLength() + 4);
        outBuffer.writeInt(message.getLength());
        if (message.getLength() > 0) {
            outBuffer.writeByte(message.getId());
            message.write(outBuffer);
        }
        this.outStream.write(outBuffer.toByteArray());
        this.outStream.flush();
        this.lastActivity = LocalDateTime.now(this.clock);
    }

    public void sendHandshake(byte[] extensionBytes, byte[] peerId, byte[] torrentHash) throws IOException {
        if (this.passedHandshake) {
            throw new IllegalStateException("Handshake has already been completed.");
        }
        this.outStream.writeByte(19);
        this.outStream.writeString("BitTorrent protocol");
        this.outStream.write(extensionBytes);
        this.outStream.write(torrentHash);
        this.outStream.write(peerId);
        this.outStream.flush();
    }

    public BitTorrentHandshake readHandshake() throws IOException {
        if (this.passedHandshake) {
            throw new IllegalStateException("Handshake has already been completed.");
        }
        this.awaitHandshake();
        int protocolLength = this.inStream.read();
        if (protocolLength != 19) {
            throw new IOException("Protocol handshake failed");
        }
        String protocol = this.inStream.readString(19);
        if (!"BitTorrent protocol".equals(protocol)) {
            throw new IOException("Protocol handshake failed");
        }
        byte[] extensionBytes = this.inStream.readByteArray(8);
        byte[] torrentHash = this.inStream.readByteArray(20);
        byte[] peerId = this.inStream.readByteArray(20);
        return new BitTorrentHandshake(torrentHash, extensionBytes, peerId);
    }

    private void awaitHandshake() throws IOException {
        LocalDateTime startTime = LocalDateTime.now(this.clock);
        while (Duration.between(startTime, LocalDateTime.now(this.clock)).minusSeconds(5L).isNegative() && this.inStream.available() < 68) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException(e);
            }
        }
        if (this.inStream.available() < 68) {
            throw new IOException("Remote end failed to supply handshake within 5 seconds");
        }
    }

    public void pollRates() {
        if (this.inStream != null) {
            this.downloadRate = this.inStream.pollSpeed();
        }
        if (this.outStream != null) {
            this.uploadRate = this.outStream.pollSpeed();
        }
    }

    public void close() {
        if (this.socket.isClosed()) {
            return;
        }
        try {
            this.socket.close();
        }
        catch (IOException e) {
            LOGGER.warn("Failed to close socket.", (Throwable)e);
        }
    }

    public boolean canReadMessage() throws IOException {
        int remainingBytes;
        if (this.buffer == null) {
            if (this.inStream.available() < 4) {
                return false;
            }
            this.lastBufferCreate = LocalDateTime.now(this.clock);
            int length = this.inStream.readInt();
            this.buffer = new OutStream(length + 4);
            this.bufferSize = length + 4;
            this.buffer.writeInt(length);
        }
        if ((remainingBytes = this.bufferSize - this.buffer.size()) == 0) {
            return true;
        }
        int availableBytes = Math.min(remainingBytes, this.inStream.available());
        this.buffer.write(this.inStream.readByteArray(availableBytes));
        this.lastActivity = LocalDateTime.now(this.clock);
        return this.bufferSize - this.buffer.size() == 0;
    }

    private InStream getBufferedMessage() {
        InStream bufferedStream = new InStream(this.buffer.toByteArray(), this.getBufferLifetime());
        this.buffer = null;
        return bufferedStream;
    }

    private Duration getBufferLifetime() {
        return Duration.between(this.lastBufferCreate, LocalDateTime.now(this.clock));
    }

    public int getDownloadRate() {
        return this.downloadRate;
    }

    public int getUploadRate() {
        return this.uploadRate;
    }

    public boolean closed() {
        if (this.socket == null) {
            return true;
        }
        return this.socket.isClosed();
    }

    public boolean getPassedHandshake() {
        return this.passedHandshake;
    }

    public void setPassedHandshake() {
        this.passedHandshake = true;
    }

    public boolean hasOutboundMessages() {
        return !this.messageQueue.isEmpty() || !this.blockQueue.isEmpty();
    }

    public String getSocketName() {
        if (this.socket == null) {
            return "";
        }
        return this.socket.getClass().getSimpleName();
    }

    public String toString() {
        return String.format("BitTorrentSocket[socket=%s]", this.socket);
    }

    public LocalDateTime getLastActivity() {
        return this.lastActivity;
    }
}

