/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.network;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.johnnei.javatorrent.internal.network.socket.ISocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionDegradation {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionDegradation.class);
    private final Class<? extends ISocket> preferredType;
    private final Map<Class<? extends ISocket>, Class<? extends ISocket>> socketDegradation;
    private final Map<Class<? extends ISocket>, Supplier<? extends ISocket>> socketSuppliers;

    private ConnectionDegradation(Builder builder) {
        this.preferredType = builder.preferredType;
        this.socketDegradation = builder.socketDegradation;
        this.socketSuppliers = builder.socketSuppliers;
    }

    public ISocket createPreferredSocket() {
        return this.socketSuppliers.get(this.preferredType).get();
    }

    public Optional<ISocket> degradeSocket(ISocket socket) {
        if (!this.socketDegradation.containsKey(socket.getClass())) {
            return Optional.empty();
        }
        Class<? extends ISocket> fallbackType = this.socketDegradation.get(socket.getClass());
        return Optional.of(this.socketSuppliers.get(fallbackType).get());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("ConnectionDegradation[");
        Class<? extends ISocket> type = this.preferredType;
        while (type != null) {
            stringBuilder.append(type.getSimpleName());
            if ((type = this.socketDegradation.get(type)) == null) continue;
            stringBuilder.append(" -> ");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static class Builder {
        private Class<? extends ISocket> preferredType;
        private Map<Class<? extends ISocket>, Class<? extends ISocket>> socketDegradation = new HashMap<Class<? extends ISocket>, Class<? extends ISocket>>();
        private Map<Class<? extends ISocket>, Supplier<? extends ISocket>> socketSuppliers = new HashMap<Class<? extends ISocket>, Supplier<? extends ISocket>>();

        public <T extends ISocket> Builder registerDefaultConnectionType(Class<T> socketType, Supplier<T> supplier, Optional<Class<? extends ISocket>> fallbackType) {
            Objects.requireNonNull(socketType, "Socket type can not be null");
            if (this.preferredType != null) {
                LOGGER.warn("Overriding existing default connection type: {}.", (Object)this.preferredType.getSimpleName());
            }
            this.preferredType = socketType;
            this.registerConnectionType(socketType, supplier, fallbackType);
            return this;
        }

        public <T extends ISocket> Builder registerConnectionType(Class<T> socketType, Supplier<T> supplier, Optional<Class<? extends ISocket>> fallbackType) {
            Objects.requireNonNull(socketType, "Socket type can not be null");
            Objects.requireNonNull(supplier, "Socket supplier can not be null");
            this.socketSuppliers.put(socketType, supplier);
            this.registerFallback(socketType, fallbackType);
            return this;
        }

        private void registerFallback(Class<? extends ISocket> from, Optional<Class<? extends ISocket>> to) {
            if (!to.isPresent()) {
                return;
            }
            this.socketDegradation.put(from, to.get());
        }

        public ConnectionDegradation build() {
            if (this.preferredType == null) {
                throw new IllegalStateException("No preferred connection type has been configured.");
            }
            LOGGER.debug("Preferred Connection: {}", (Object)this.preferredType.getSimpleName());
            this.verifySocketChain();
            return new ConnectionDegradation(this);
        }

        private void verifySocketChain() {
            int typesSeen = 0;
            Class<? extends ISocket> type = this.preferredType;
            while (type != null) {
                if (!this.socketSuppliers.containsKey(type)) {
                    throw new IllegalStateException(String.format("Socket supplier for type %s has not been set.", type.getSimpleName()));
                }
                type = this.socketDegradation.get(type);
                ++typesSeen;
            }
            if (typesSeen != this.socketSuppliers.size()) {
                LOGGER.warn("Socket chain does not contain all types. Chain contains {} types, whilst {} have been registered.", (Object)typesSeen, (Object)this.socketSuppliers.size());
            }
        }
    }
}

