/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.network;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.Optional;
import org.johnnei.javatorrent.internal.utils.CheckedRunnable;
import org.johnnei.javatorrent.internal.utils.CheckedSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InStream {
    private static final Logger LOGGER = LoggerFactory.getLogger(InStream.class);
    private Duration readDuration;
    private ByteArrayInputStream buffer;
    private DataInputStream in;
    private int length;

    public InStream(byte[] data) {
        this(data, 0, data.length, null);
    }

    public InStream(byte[] data, Duration readDuration) {
        this(data, 0, data.length, readDuration);
    }

    public InStream(byte[] data, int offset, int length) {
        this(data, offset, length, null);
    }

    public InStream(byte[] data, int offset, int length, Duration readDuration) {
        this.buffer = new ByteArrayInputStream(data, offset, length);
        this.in = new DataInputStream(this.buffer);
        this.length = length;
        this.readDuration = readDuration;
    }

    public boolean readBoolean() {
        return this.doUnchecked(() -> this.in.readBoolean());
    }

    public byte readByte() {
        return this.doUnchecked(() -> this.in.readByte());
    }

    public char readChar() {
        return this.doUnchecked(() -> Character.valueOf(this.in.readChar())).charValue();
    }

    public void readFully(byte[] b) {
        this.readFully(b, 0, b.length);
    }

    public void readFully(byte[] b, int off, int len) {
        this.doUnchecked(() -> this.in.readFully(b, off, len));
    }

    public byte[] readFully(int length) {
        byte[] array = new byte[length];
        this.readFully(array);
        return array;
    }

    public int readInt() {
        return this.doUnchecked(() -> this.in.readInt());
    }

    public long readLong() {
        return this.doUnchecked(() -> this.in.readLong());
    }

    public short readShort() {
        return this.doUnchecked(() -> this.in.readShort());
    }

    public int readUnsignedByte() {
        return this.doUnchecked(() -> this.in.readUnsignedByte());
    }

    public int readUnsignedShort() {
        return this.doUnchecked(() -> this.in.readUnsignedShort());
    }

    public int skipBytes(int n) {
        return this.doUnchecked(() -> this.in.skipBytes(n));
    }

    public void moveBack(int n) {
        int offset = this.length - this.buffer.available() - n;
        this.buffer.reset();
        this.skipBytes(offset);
    }

    public int available() {
        return this.doUnchecked(() -> this.in.available());
    }

    public String readString(int length) {
        byte[] stringBytes = this.readFully(length);
        return new String(stringBytes, Charset.forName("UTF-8"));
    }

    public void mark() {
        this.buffer.mark(this.buffer.available());
    }

    public void resetToMark() {
        this.buffer.reset();
    }

    public Optional<Duration> getReadDuration() {
        return Optional.ofNullable(this.readDuration);
    }

    private void doUnchecked(CheckedRunnable<IOException> readCall) {
        try {
            readCall.run();
        }
        catch (IOException e) {
            LOGGER.error("You managed to cause an IO exception on an in-memory byte array. I'm proud.", (Throwable)e);
            throw new RuntimeException("IO Exception on in-memory byte array", e);
        }
    }

    private <T> T doUnchecked(CheckedSupplier<T, IOException> readCall) {
        try {
            return readCall.get();
        }
        catch (IOException e) {
            LOGGER.error("You managed to cause an IO exception on an in-memory byte array. I'm proud.", (Throwable)e);
            throw new RuntimeException("IO Exception on in-memory byte array", e);
        }
    }
}

