/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.phases;

import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import org.johnnei.javatorrent.TorrentClient;
import org.johnnei.javatorrent.bittorrent.tracker.TrackerEvent;
import org.johnnei.javatorrent.phases.IDownloadPhase;
import org.johnnei.javatorrent.torrent.Torrent;
import org.johnnei.javatorrent.torrent.algos.choking.IChokingStrategy;
import org.johnnei.javatorrent.torrent.algos.choking.PermissiveStrategy;
import org.johnnei.javatorrent.torrent.algos.pieceselector.FullPieceSelect;
import org.johnnei.javatorrent.torrent.files.Block;
import org.johnnei.javatorrent.torrent.files.BlockStatus;
import org.johnnei.javatorrent.torrent.files.Piece;
import org.johnnei.javatorrent.torrent.peer.Peer;
import org.johnnei.javatorrent.torrent.peer.PeerDirection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhaseData
implements IDownloadPhase {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhaseData.class);
    private final Torrent torrent;
    private final TorrentClient torrentClient;
    private final IChokingStrategy chokingStrategy;

    public PhaseData(TorrentClient torrentClient, Torrent torrent) {
        this.torrentClient = torrentClient;
        this.torrent = torrent;
        this.chokingStrategy = new PermissiveStrategy();
    }

    @Override
    public boolean isDone() {
        return this.torrent.getFileSet().isDone();
    }

    @Override
    public void process() {
        for (Peer peer : this.getRelevantPeers(this.torrent.getPeers())) {
            Optional<Block> blockOptional;
            Optional<Piece> pieceOptional = this.torrent.getPieceSelector().getPieceForPeer(peer);
            if (!pieceOptional.isPresent()) continue;
            Piece piece = pieceOptional.get();
            while (piece.hasBlockWithStatus(BlockStatus.Needed) && peer.getFreeWorkTime() > 0 && (blockOptional = piece.getRequestBlock()).isPresent()) {
                Block block = blockOptional.get();
                peer.addBlockRequest(piece.getIndex(), this.torrent.getFileSet().getBlockSize() * block.getIndex(), block.getSize(), PeerDirection.Download);
            }
        }
    }

    @Override
    public void onPhaseEnter() {
        this.torrent.checkProgress();
        this.torrent.setPieceSelector(new FullPieceSelect(this.torrent));
    }

    @Override
    public void onPhaseExit() {
        this.torrentClient.getTrackersFor(this.torrent).forEach(tracker -> tracker.getInfo(this.torrent).get().setEvent(TrackerEvent.EVENT_COMPLETED));
        LOGGER.info("Download of {} completed", (Object)this.torrent);
    }

    Collection<Peer> getRelevantPeers(Collection<Peer> peers) {
        Collection neededPiece = this.torrent.getFileSet().getNeededPieces().collect(Collectors.toList());
        return peers.stream().filter(peer -> neededPiece.stream().anyMatch(piece -> peer.hasPiece(piece.getIndex()))).collect(Collectors.toList());
    }

    @Override
    public IChokingStrategy getChokingStrategy() {
        return this.chokingStrategy;
    }
}

