/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.torrent;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileInfo.class);
    private String fileName;
    private long filesize;
    private int pieceCount;
    private long firstByteOffset;
    private RandomAccessFile fileAccess;
    public final Object fileLock = new Object();

    public FileInfo(long filesize, long firstByteOffset, File file, int pieceCount) {
        this.firstByteOffset = firstByteOffset;
        this.fileName = file.getName();
        this.filesize = filesize;
        this.pieceCount = pieceCount;
        try {
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            this.fileAccess = new RandomAccessFile(file, "rw");
        }
        catch (IOException ex) {
            LOGGER.warn("Failed to open read/write access to {}", (Object)file.getAbsolutePath(), (Object)ex);
        }
    }

    public int getPieceCount() {
        return this.pieceCount;
    }

    public long getSize() {
        return this.filesize;
    }

    public long getFirstByteOffset() {
        return this.firstByteOffset;
    }

    public String getFileName() {
        return this.fileName;
    }

    public RandomAccessFile getFileAccess() {
        return this.fileAccess;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof FileInfo)) {
            return false;
        }
        FileInfo fileInfo = (FileInfo)o;
        return this.filesize == fileInfo.filesize && this.firstByteOffset == fileInfo.firstByteOffset;
    }

    public int hashCode() {
        return Objects.hash(this.filesize, this.firstByteOffset);
    }

    public String toString() {
        return String.format("FileInfo[firstByteOffset=%d, length=%d, name=%s]", this.firstByteOffset, this.filesize, this.fileName);
    }
}

