/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.torrent;

import java.io.File;
import java.util.ArrayList;
import org.johnnei.javatorrent.torrent.AbstractFileSet;
import org.johnnei.javatorrent.torrent.FileInfo;
import org.johnnei.javatorrent.torrent.Torrent;
import org.johnnei.javatorrent.torrent.files.Piece;
import org.johnnei.javatorrent.utils.Argument;

public class MetadataFileSet
extends AbstractFileSet {
    public static final int BLOCK_SIZE = 16384;
    private int fileSize;

    public MetadataFileSet(Torrent torrent, File metadataFile) {
        super(16384);
        Argument.requireNonNull(torrent, "Torrent cannot be null.");
        Argument.requireNonNull(metadataFile, "Metadata file cannot be null.");
        if (!metadataFile.exists()) {
            throw new IllegalArgumentException("Metadata file must exist.");
        }
        this.fileSize = (int)metadataFile.length();
        this.fileInfos = new ArrayList();
        this.fileInfos.add(new FileInfo(this.fileSize, 0L, metadataFile, 1));
        this.pieces = new ArrayList(1);
        this.pieces.add(new Piece(this, torrent.getHashArray(), 0, this.fileSize, 16384));
    }

    @Override
    public long getPieceSize() {
        return this.fileSize;
    }

    @Override
    public byte[] getBitfieldBytes() {
        throw new UnsupportedOperationException("UT_METADATA does not support bitfield.");
    }
}

