/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.torrent;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.johnnei.javatorrent.TorrentClient;
import org.johnnei.javatorrent.bittorrent.encoding.SHA1;
import org.johnnei.javatorrent.bittorrent.protocol.messages.IMessage;
import org.johnnei.javatorrent.bittorrent.protocol.messages.MessageBitfield;
import org.johnnei.javatorrent.bittorrent.protocol.messages.MessageHave;
import org.johnnei.javatorrent.disk.DiskJobCheckHash;
import org.johnnei.javatorrent.disk.DiskJobWriteBlock;
import org.johnnei.javatorrent.disk.IDiskJob;
import org.johnnei.javatorrent.module.IModule;
import org.johnnei.javatorrent.torrent.AbstractFileSet;
import org.johnnei.javatorrent.torrent.MetadataFileSet;
import org.johnnei.javatorrent.torrent.TorrentFileSet;
import org.johnnei.javatorrent.torrent.algos.pieceselector.FullPieceSelect;
import org.johnnei.javatorrent.torrent.algos.pieceselector.IPieceSelector;
import org.johnnei.javatorrent.torrent.files.BlockStatus;
import org.johnnei.javatorrent.torrent.files.Piece;
import org.johnnei.javatorrent.torrent.peer.Peer;
import org.johnnei.javatorrent.utils.Argument;
import org.johnnei.javatorrent.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Torrent {
    private static final Logger LOGGER = LoggerFactory.getLogger(Torrent.class);
    private String displayName;
    private byte[] btihHash;
    private List<Peer> peers;
    private AbstractFileSet files;
    private MetadataFileSet metadata;
    private IPieceSelector pieceSelector;
    private long downloadedBytes;
    private long uploadedBytes;
    private TorrentClient torrentClient;

    public Torrent(Builder builder) {
        this.displayName = Argument.requireNonNull(builder.displayName, "Torrent name is required");
        this.torrentClient = builder.torrentClient;
        this.btihHash = builder.hash;
        this.downloadedBytes = 0L;
        this.peers = new LinkedList<Peer>();
        this.pieceSelector = new FullPieceSelect(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasPeer(Peer peer) {
        Torrent torrent = this;
        synchronized (torrent) {
            return this.peers.contains(peer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPeer(Peer peer) throws IOException {
        Argument.requireNonNull(peer, "Peer can not be null");
        if (this.hasPeer(peer)) {
            peer.getBitTorrentSocket().close();
            LOGGER.trace("Filtered duplicate Peer: {}", (Object)peer);
            return;
        }
        peer.getBitTorrentSocket().setPassedHandshake();
        for (IModule module : this.torrentClient.getModules()) {
            module.onPostHandshake(peer);
        }
        this.sendHaveMessages(peer);
        Torrent torrent = this;
        synchronized (torrent) {
            this.peers.add(peer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePeer(Peer peer) {
        Argument.requireNonNull(peer, "Peer can not be null");
        Torrent torrent = this;
        synchronized (torrent) {
            if (!this.peers.remove(peer)) {
                return;
            }
        }
        peer.discardAllBlockRequests();
    }

    private void sendHaveMessages(Peer peer) throws IOException {
        if (this.isDownloadingMetadata()) {
            return;
        }
        if (this.files.countCompletedPieces() == 0) {
            return;
        }
        boolean bitfieldOverhead = true;
        int bitfieldPacketSize = this.files.getBitfieldBytes().length + 1;
        int haveOverheadPerPiece = 5;
        int havePacketsSize = this.files.countCompletedPieces() * 5;
        if (bitfieldPacketSize < havePacketsSize) {
            peer.getBitTorrentSocket().enqueueMessage(new MessageBitfield(this.files.getBitfieldBytes()));
        } else {
            for (int pieceIndex = 0; pieceIndex < this.files.getPieceCount(); ++pieceIndex) {
                if (!this.files.hasPiece(pieceIndex)) continue;
                peer.getBitTorrentSocket().enqueueMessage(new MessageHave(pieceIndex));
            }
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public byte[] getHashArray() {
        return this.btihHash;
    }

    public String getHash() {
        return StringUtils.byteArrayToString(this.btihHash);
    }

    public boolean isDownloadingMetadata() {
        if (this.metadata == null) {
            return true;
        }
        if (!this.metadata.isDone()) {
            return true;
        }
        return this.files == null;
    }

    public void onReceivedBlock(AbstractFileSet fileSet, int index, int offset, byte[] data) {
        int blockIndex = offset / fileSet.getBlockSize();
        Piece piece = fileSet.getPiece(index);
        if (piece.getBlockSize(blockIndex) != data.length) {
            LOGGER.debug("Received incorrect sized block for piece {}, offset {}", (Object)index, (Object)offset);
            piece.setBlockStatus(blockIndex, BlockStatus.Needed);
        } else {
            this.addDiskJob(new DiskJobWriteBlock(piece, blockIndex, data, this::onStoreBlockComplete));
        }
    }

    private void onStoreBlockComplete(DiskJobWriteBlock storeBlock) {
        Piece piece = storeBlock.getPiece();
        piece.setBlockStatus(storeBlock.getBlockIndex(), BlockStatus.Stored);
        if (piece.countBlocksWithStatus(BlockStatus.Stored) != piece.getBlockCount()) {
            return;
        }
        this.addDiskJob(new DiskJobCheckHash(piece, this::onCheckPieceHashComplete));
    }

    private void onCheckPieceHashComplete(DiskJobCheckHash checkJob) {
        Piece piece = checkJob.getPiece();
        if (!checkJob.isMatchingHash()) {
            LOGGER.debug("Piece hash mismatched");
            piece.onHashMismatch();
            return;
        }
        if (this.isDownloadingMetadata()) {
            this.metadata.setHavingPiece(piece.getIndex());
        } else {
            this.files.setHavingPiece(piece.getIndex());
            this.broadcastMessage(new MessageHave(piece.getIndex()));
            this.downloadedBytes += (long)piece.getSize();
        }
        LOGGER.debug("Completed piece {}", (Object)piece.getIndex());
    }

    public void addDiskJob(IDiskJob task) {
        this.torrentClient.addDiskJob(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcastMessage(IMessage m) {
        Torrent torrent = this;
        synchronized (torrent) {
            this.peers.stream().forEach(p -> p.getBitTorrentSocket().enqueueMessage(m));
        }
    }

    public void checkProgress() {
        LOGGER.info("Checking progress...");
        this.files.getNeededPieces().filter(p -> {
            try {
                return p.checkHash();
            }
            catch (IOException e) {
                LOGGER.warn("Failed hash check for piece {}.", (Object)p.getIndex(), (Object)e);
                return false;
            }
        }).forEach(p -> {
            this.files.setHavingPiece(p.getIndex());
            this.broadcastMessage(new MessageHave(p.getIndex()));
        });
        LOGGER.info("Checking progress done");
    }

    public void addUploadedBytes(long l) {
        this.uploadedBytes += l;
    }

    public void setFileSet(AbstractFileSet files) {
        this.files = files;
    }

    public void setMetadata(MetadataFileSet metadata) {
        this.metadata = Argument.requireNonNull(metadata, "Metadata can not be set to null");
    }

    public Optional<MetadataFileSet> getMetadata() {
        return Optional.ofNullable(this.metadata);
    }

    public String toString() {
        return String.format("Torrent[hash=%s]", this.getHash());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pollRates() {
        Torrent torrent = this;
        synchronized (torrent) {
            this.peers.forEach(p -> p.getBitTorrentSocket().pollRates());
        }
    }

    public AbstractFileSet getFileSet() {
        return this.files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDownloadRate() {
        Torrent torrent = this;
        synchronized (torrent) {
            return this.peers.stream().mapToInt(p -> p.getBitTorrentSocket().getDownloadRate()).sum();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUploadRate() {
        Torrent torrent = this;
        synchronized (torrent) {
            return this.peers.stream().mapToInt(p -> p.getBitTorrentSocket().getUploadRate()).sum();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSeedCount() {
        if (this.isDownloadingMetadata()) {
            return 0;
        }
        Torrent torrent = this;
        synchronized (torrent) {
            return (int)this.peers.stream().filter(p -> p.countHavePieces() == this.files.getPieceCount()).count();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLeecherCount() {
        Torrent torrent = this;
        synchronized (torrent) {
            return (int)(this.peers.stream().count() - (long)this.getSeedCount());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Peer> getPeers() {
        Torrent torrent = this;
        synchronized (torrent) {
            return new ArrayList<Peer>(this.peers);
        }
    }

    public long getDownloadedBytes() {
        return this.downloadedBytes;
    }

    public long getUploadedBytes() {
        return this.uploadedBytes;
    }

    public IPieceSelector getPieceSelector() {
        return this.pieceSelector;
    }

    public int hashCode() {
        return Arrays.hashCode(this.btihHash);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Torrent)) {
            return false;
        }
        Torrent other = (Torrent)obj;
        return Arrays.equals(this.btihHash, other.btihHash);
    }

    public void setPieceSelector(IPieceSelector downloadRegulator) {
        this.pieceSelector = downloadRegulator;
    }

    public static final class Builder {
        private TorrentClient torrentClient;
        private String displayName;
        private byte[] hash;

        public Builder setTorrentClient(TorrentClient torrentClient) {
            this.torrentClient = torrentClient;
            return this;
        }

        public Builder setHash(byte[] hash) {
            this.hash = hash;
            return this;
        }

        public Builder setName(String name) {
            this.displayName = name;
            return this;
        }

        public boolean canDownload() {
            return this.hash != null;
        }

        public Torrent build() {
            return new Torrent(this);
        }

        public Torrent buildFromMetata(File metadata, File downloadFolder) throws IOException {
            try (DataInputStream inputStream = new DataInputStream(new FileInputStream(metadata));){
                byte[] data = new byte[(int)metadata.length()];
                inputStream.readFully(data);
                this.setHash(SHA1.hash(data));
            }
            Torrent torrent = this.build();
            MetadataFileSet metadataFileSet = new MetadataFileSet(torrent, metadata);
            metadataFileSet.getNeededPieces().forEach(p -> metadataFileSet.setHavingPiece(p.getIndex()));
            TorrentFileSet fileSet = new TorrentFileSet(metadata, downloadFolder);
            torrent.setMetadata(metadataFileSet);
            torrent.setFileSet(fileSet);
            return torrent;
        }
    }
}

