/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.tracker;

import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.johnnei.javatorrent.TorrentClient;
import org.johnnei.javatorrent.async.LoopingRunnable;
import org.johnnei.javatorrent.bittorrent.protocol.BitTorrentHandshake;
import org.johnnei.javatorrent.network.BitTorrentSocket;
import org.johnnei.javatorrent.network.PeerConnectInfo;
import org.johnnei.javatorrent.torrent.Torrent;
import org.johnnei.javatorrent.torrent.peer.Peer;
import org.johnnei.javatorrent.tracker.IPeerConnector;
import org.johnnei.javatorrent.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerConnector
implements Runnable,
IPeerConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(PeerConnector.class);
    private final Object peerListLock = new Object();
    private final Lock newPeerLock = new ReentrantLock();
    private final Condition newPeerCondition = this.newPeerLock.newCondition();
    private LinkedList<PeerConnectInfo> peers;
    private final LoopingRunnable runnable;
    private final TorrentClient torrentClient;

    public PeerConnector(TorrentClient torrentClient) {
        this.torrentClient = torrentClient;
        this.runnable = new LoopingRunnable(this);
        this.peers = new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueuePeer(PeerConnectInfo peerInfo) {
        if (peerInfo == null) {
            return;
        }
        Object object = this.peerListLock;
        synchronized (object) {
            this.peers.add(peerInfo);
        }
        this.newPeerLock.lock();
        try {
            this.newPeerCondition.signal();
        }
        finally {
            this.newPeerLock.unlock();
        }
    }

    @Override
    public void start() {
        Thread thread = new Thread((Runnable)this.runnable, "Peer Connector");
        thread.setDaemon(true);
        thread.start();
    }

    @Override
    public void stop() {
        this.runnable.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        PeerConnectInfo peerInfo;
        while (this.peers.isEmpty()) {
            this.newPeerLock.lock();
            try {
                this.newPeerCondition.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            finally {
                this.newPeerLock.unlock();
            }
        }
        Object object = this.peerListLock;
        synchronized (object) {
            peerInfo = this.peers.remove();
        }
        if (this.torrentClient.getPeerDistributor().hasReachedPeerLimit(peerInfo.getTorrent())) {
            this.torrentClient.getExecutorService().schedule(() -> this.enqueuePeer(peerInfo), 10L, TimeUnit.SECONDS);
            return;
        }
        BitTorrentSocket peerSocket = this.createUnconnectedSocket();
        try {
            peerSocket.connect(this.torrentClient.getConnectionDegradation(), peerInfo.getAddress());
            peerSocket.sendHandshake(this.torrentClient.getExtensionBytes(), this.torrentClient.getPeerId(), peerInfo.getTorrent().getHashArray());
            BitTorrentHandshake handshake = this.checkHandshake(peerSocket, peerInfo.getTorrent().getHashArray());
            Peer peer = new Peer.Builder().setSocket(peerSocket).setTorrent(peerInfo.getTorrent()).setExtensionBytes(handshake.getPeerExtensionBytes()).setId(handshake.getPeerId()).build();
            LOGGER.debug("Connected with {}:{}", (Object)peerInfo.getAddress().getAddress(), (Object)peerInfo.getAddress().getPort());
            peerInfo.getTorrent().addPeer(peer);
        }
        catch (IOException e) {
            LOGGER.debug("Failed to connect to peer ({}:{})", new Object[]{peerInfo.getAddress().getAddress(), peerInfo.getAddress().getPort(), e});
            peerSocket.close();
        }
    }

    BitTorrentSocket createUnconnectedSocket() {
        return new BitTorrentSocket(this.torrentClient.getMessageFactory());
    }

    private BitTorrentHandshake checkHandshake(BitTorrentSocket peerSocket, byte[] torrentHash) throws IOException {
        BitTorrentHandshake handshake = peerSocket.readHandshake();
        if (!Arrays.equals(torrentHash, handshake.getTorrentHash())) {
            throw new IOException(String.format("Peer does not download the same torrent (Expected: %s, Got: %s)", StringUtils.byteArrayToString(torrentHash), StringUtils.byteArrayToString(handshake.getTorrentHash())));
        }
        return handshake;
    }

    @Override
    public int getConnectingCount() {
        return this.peers.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getConnectingCountFor(Torrent torrent) {
        LinkedList<PeerConnectInfo> peerList;
        Object object = this.peerListLock;
        synchronized (object) {
            peerList = new LinkedList<PeerConnectInfo>(this.peers);
        }
        return (int)peerList.stream().filter(p -> p.getTorrent().equals(torrent)).count();
    }
}

