/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.async;

import org.johnnei.javatorrent.utils.Argument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoopingRunnable
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoopingRunnable.class);
    private final Runnable runnable;
    private final boolean isEventBased;
    private volatile boolean keepRunning;

    public LoopingRunnable(Runnable runnable) {
        this(runnable, false);
    }

    public LoopingRunnable(Runnable runnable, boolean isEventBased) {
        this.runnable = Argument.requireNonNull(runnable, "Runnable not cannot be null");
        this.isEventBased = isEventBased;
        this.keepRunning = true;
    }

    public void stop() {
        LOGGER.debug("Stopping {}", (Object)this.runnable);
        this.keepRunning = false;
    }

    @Override
    public void run() {
        LOGGER.debug("Started {}", (Object)this.runnable);
        while (this.keepRunning) {
            this.runnable.run();
            if (this.isEventBased) continue;
            this.throttleThread();
        }
        LOGGER.debug("Completed {}", (Object)this.runnable);
    }

    private void throttleThread() {
        try {
            Thread.sleep(5L);
        }
        catch (InterruptedException e) {
            LOGGER.trace("Ignoring interrupted exception for endless looping task.", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }
}

