/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.bittorrent.encoding;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.johnnei.javatorrent.bittorrent.encoding.AbstractBencodedValue;
import org.johnnei.javatorrent.bittorrent.protocol.BitTorrent;

public class BencodedInteger
extends AbstractBencodedValue {
    private static final BigInteger MAX_LONG_VALUE = BigInteger.valueOf(Long.MAX_VALUE);
    private static final BigInteger MIN_LONG_VALUE = BigInteger.valueOf(Long.MIN_VALUE);
    private static final byte[] ENTRY_START_BYTES = "i".getBytes(BitTorrent.DEFAULT_ENCODING);
    private BigInteger bigInteger;

    public BencodedInteger(long integerValue) {
        this(BigInteger.valueOf(integerValue));
    }

    public BencodedInteger(BigInteger bigInteger) {
        this.bigInteger = bigInteger;
    }

    @Override
    public long asLong() {
        if (this.bigInteger.compareTo(MAX_LONG_VALUE) > 0 || this.bigInteger.compareTo(MIN_LONG_VALUE) < 0) {
            throw new UnsupportedOperationException("Integer value is out of range to fit in a long.");
        }
        return this.bigInteger.longValueExact();
    }

    @Override
    public BigInteger asBigInteger() {
        return this.bigInteger;
    }

    @Override
    public byte[] serialize() {
        byte[] integerBytes = this.bigInteger.toString().getBytes(BitTorrent.DEFAULT_ENCODING);
        ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[ENTRY_START_BYTES.length + integerBytes.length + ENTRY_END_BYTES.length]);
        byteBuffer.put(ENTRY_START_BYTES);
        byteBuffer.put(integerBytes);
        byteBuffer.put(ENTRY_END_BYTES);
        return byteBuffer.array();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof BencodedInteger)) {
            return false;
        }
        BencodedInteger integer = (BencodedInteger)o;
        return Objects.equals(this.bigInteger, integer.bigInteger);
    }

    public int hashCode() {
        return Objects.hash(this.bigInteger);
    }

    public String toString() {
        return String.format("BencodedInteger[value=%s]", this.bigInteger);
    }
}

