/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.bittorrent.encoding;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.johnnei.javatorrent.bittorrent.encoding.AbstractBencodedValue;
import org.johnnei.javatorrent.bittorrent.encoding.IBencodedValue;
import org.johnnei.javatorrent.bittorrent.protocol.BitTorrent;

public class BencodedList
extends AbstractBencodedValue {
    private static final byte[] ENTRY_START_BYTES = "l".getBytes(BitTorrent.DEFAULT_ENCODING);
    private List<IBencodedValue> bencodedValues = new ArrayList<IBencodedValue>();

    public IBencodedValue get(int index) {
        return this.bencodedValues.get(index);
    }

    public void add(IBencodedValue value) {
        this.bencodedValues.add(value);
    }

    public int size() {
        return this.bencodedValues.size();
    }

    @Override
    public List<IBencodedValue> asList() {
        return Collections.unmodifiableList(this.bencodedValues);
    }

    @Override
    public byte[] serialize() {
        byte[][] serializedValues = new byte[this.bencodedValues.size()][];
        int serializedValuesByteCount = 0;
        int index = 0;
        for (IBencodedValue bencodedValue : this.bencodedValues) {
            serializedValues[index] = bencodedValue.serialize();
            serializedValuesByteCount += serializedValues[index].length;
            ++index;
        }
        ByteBuffer buffer = ByteBuffer.wrap(new byte[ENTRY_START_BYTES.length + ENTRY_END_BYTES.length + serializedValuesByteCount]);
        buffer.put(ENTRY_START_BYTES);
        for (byte[] serializedEntry : serializedValues) {
            buffer.put(serializedEntry);
        }
        buffer.put(ENTRY_END_BYTES);
        return buffer.array();
    }
}

