/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.bittorrent.encoding;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.johnnei.javatorrent.bittorrent.encoding.AbstractBencodedValue;
import org.johnnei.javatorrent.bittorrent.encoding.BencodedString;
import org.johnnei.javatorrent.bittorrent.encoding.IBencodedValue;
import org.johnnei.javatorrent.bittorrent.protocol.BitTorrent;

public class BencodedMap
extends AbstractBencodedValue {
    private static final byte[] ENTRY_START_BYTES = "d".getBytes(BitTorrent.DEFAULT_ENCODING);
    private Map<String, IBencodedValue> map = new HashMap<String, IBencodedValue>();

    public void put(String name, IBencodedValue value) {
        this.map.put(name, value);
    }

    public Optional<IBencodedValue> get(String name) {
        return Optional.ofNullable(this.map.get(name));
    }

    public Optional<IBencodedValue> remove(String name) {
        return Optional.ofNullable(this.map.remove(name));
    }

    @Override
    public Map<String, IBencodedValue> asMap() {
        return Collections.unmodifiableMap(this.map);
    }

    @Override
    public byte[] serialize() {
        TreeMap<String, IBencodedValue> sortedMap = new TreeMap<String, IBencodedValue>(new RawStringComparator());
        sortedMap.putAll(this.map);
        Entry[] entries = new Entry[sortedMap.size()];
        int entryByteCount = 0;
        int index = 0;
        for (Map.Entry entry : sortedMap.entrySet()) {
            entries[index] = new Entry(new BencodedString((String)entry.getKey()).serialize(), ((IBencodedValue)entry.getValue()).serialize());
            entryByteCount += entries[index].keyBytes.length + entries[index].valueBytes.length;
            ++index;
        }
        ByteBuffer buffer = ByteBuffer.wrap(new byte[ENTRY_START_BYTES.length + ENTRY_END_BYTES.length + entryByteCount]);
        buffer.put(ENTRY_START_BYTES);
        for (Entry entry : entries) {
            buffer.put(entry.keyBytes);
            buffer.put(entry.valueBytes);
        }
        buffer.put(ENTRY_END_BYTES);
        return buffer.array();
    }

    private static class RawStringComparator
    implements Comparator<String> {
        private RawStringComparator() {
        }

        @Override
        public int compare(String a, String b) {
            byte[] bBytes;
            byte[] aBytes = a.getBytes(BitTorrent.DEFAULT_ENCODING);
            int lengthCompare = Integer.compare(aBytes.length, (bBytes = b.getBytes(BitTorrent.DEFAULT_ENCODING)).length);
            if (lengthCompare != 0) {
                return lengthCompare;
            }
            for (int i = 0; i < aBytes.length; ++i) {
                if (aBytes[i] == bBytes[i]) continue;
                if (aBytes[i] > bBytes[i]) {
                    return 1;
                }
                return -1;
            }
            return 0;
        }
    }

    private static class Entry {
        final byte[] keyBytes;
        final byte[] valueBytes;

        Entry(byte[] keyBytes, byte[] valueBytes) {
            this.keyBytes = keyBytes;
            this.valueBytes = valueBytes;
        }
    }
}

