/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.bittorrent.encoding;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.johnnei.javatorrent.bittorrent.encoding.AbstractBencodedValue;
import org.johnnei.javatorrent.bittorrent.protocol.BitTorrent;

public class BencodedString
extends AbstractBencodedValue {
    private static final byte[] SEPARATOR_BYTES = ":".getBytes(BitTorrent.DEFAULT_ENCODING);
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private byte[] value;

    public BencodedString(String value) {
        this.value = value.getBytes(UTF8);
    }

    public BencodedString(byte[] value) {
        this.value = value;
    }

    @Override
    public String asString() {
        return new String(this.value, UTF8);
    }

    @Override
    public byte[] asBytes() {
        return Arrays.copyOf(this.value, this.value.length);
    }

    @Override
    public byte[] serialize() {
        byte[] lengthBytes = Integer.toString(this.value.length).getBytes(BitTorrent.DEFAULT_ENCODING);
        ByteBuffer buffer = ByteBuffer.wrap(new byte[lengthBytes.length + SEPARATOR_BYTES.length + this.value.length]);
        buffer.put(lengthBytes);
        buffer.put(SEPARATOR_BYTES);
        buffer.put(this.value);
        return buffer.array();
    }

    public String toString() {
        return String.format("BencodedString[value=%s]", this.asString());
    }
}

