/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.bittorrent.encoding;

import java.io.IOException;
import java.math.BigInteger;
import org.johnnei.javatorrent.bittorrent.encoding.AbstractBencodedValue;
import org.johnnei.javatorrent.bittorrent.encoding.BencodedInteger;
import org.johnnei.javatorrent.bittorrent.encoding.BencodedList;
import org.johnnei.javatorrent.bittorrent.encoding.BencodedMap;
import org.johnnei.javatorrent.bittorrent.encoding.BencodedString;
import org.johnnei.javatorrent.bittorrent.encoding.IBencodedValue;
import org.johnnei.javatorrent.network.InStream;

public class Bencoding {
    private int charactersRead;

    public IBencodedValue decode(InStream inStream) {
        try {
            this.charactersRead = 0;
            return this.decodeNextValue(inStream);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to decode bencoded values.", e);
        }
    }

    private IBencodedValue decodeNextValue(InStream inStream) throws IOException {
        char token = this.peekCharacter(inStream);
        AbstractBencodedValue value = 'i' == token ? this.decodeInteger(inStream) : ('l' == token ? this.decodeList(inStream) : ('d' == token ? this.decodeMap(inStream) : this.decodeString(inStream)));
        return value;
    }

    private BencodedList decodeList(InStream inStream) throws IOException {
        this.consumeToken('l', inStream);
        BencodedList list = new BencodedList();
        try {
            char token = this.peekCharacter(inStream);
            while ('e' != token) {
                list.add(this.decodeNextValue(inStream));
                token = this.peekCharacter(inStream);
            }
        }
        catch (Exception e) {
            throw new IOException("Failed to read entry for list: " + list.asList().toString(), e);
        }
        this.consumeToken('e', inStream);
        return list;
    }

    private BencodedString decodeString(InStream inStream) throws IOException {
        StringBuilder length = new StringBuilder();
        char token = this.peekCharacter(inStream);
        while (':' != token) {
            length.append(this.readCharacter(inStream));
            token = this.peekCharacter(inStream);
        }
        this.consumeToken(':', inStream);
        int stringLength = Integer.parseInt(length.toString());
        if (inStream.available() < stringLength) {
            throw new IOException(String.format("Failed to decode Bencoded string. Need %d bytes but only got %d.", stringLength, inStream.available()));
        }
        byte[] stringBytes = inStream.readFully(stringLength);
        this.charactersRead += stringLength;
        return new BencodedString(stringBytes);
    }

    private BencodedMap decodeMap(InStream inStream) throws IOException {
        BencodedMap map = new BencodedMap();
        this.consumeToken('d', inStream);
        char nextToken = this.peekCharacter(inStream);
        while ('e' != nextToken) {
            BencodedString key = this.decodeString(inStream);
            try {
                IBencodedValue value = this.decodeNextValue(inStream);
                map.put(key.asString(), value);
            }
            catch (Exception e) {
                throw new IOException(String.format("Failed to read dictionary value associated with key: %s", key), e);
            }
            nextToken = this.peekCharacter(inStream);
        }
        this.consumeToken('e', inStream);
        return map;
    }

    private BencodedInteger decodeInteger(InStream inStream) throws IOException {
        this.consumeToken('i', inStream);
        StringBuilder integer = new StringBuilder();
        char nextToken = this.peekCharacter(inStream);
        while ('e' != nextToken) {
            integer.append(this.readCharacter(inStream));
            nextToken = this.peekCharacter(inStream);
        }
        this.consumeToken('e', inStream);
        return new BencodedInteger(new BigInteger(integer.toString()));
    }

    private char readCharacter(InStream inStream) throws IOException {
        if (inStream.available() == 0) {
            throw new IOException("End of Stream reached");
        }
        int character = Byte.toUnsignedInt(inStream.readByte());
        ++this.charactersRead;
        return (char)character;
    }

    private char peekCharacter(InStream inStream) throws IOException {
        inStream.mark();
        if (inStream.available() == 0) {
            throw new IOException("End of Stream reached");
        }
        char result = (char)Byte.toUnsignedInt(inStream.readByte());
        inStream.resetToMark();
        return result;
    }

    private void consumeToken(char token, InStream inStream) throws IOException {
        char readToken = this.readCharacter(inStream);
        if (token != readToken) {
            throw new IOException(String.format("Incorrect token consumed, expected '%s' but read '%s'", Character.valueOf(token), Character.valueOf(readToken)));
        }
    }
}

