/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.bittorrent.protocol;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.johnnei.javatorrent.bittorrent.protocol.messages.IMessage;
import org.johnnei.javatorrent.bittorrent.protocol.messages.MessageBitfield;
import org.johnnei.javatorrent.bittorrent.protocol.messages.MessageBlock;
import org.johnnei.javatorrent.bittorrent.protocol.messages.MessageCancel;
import org.johnnei.javatorrent.bittorrent.protocol.messages.MessageChoke;
import org.johnnei.javatorrent.bittorrent.protocol.messages.MessageHave;
import org.johnnei.javatorrent.bittorrent.protocol.messages.MessageInterested;
import org.johnnei.javatorrent.bittorrent.protocol.messages.MessageRequest;
import org.johnnei.javatorrent.bittorrent.protocol.messages.MessageUnchoke;
import org.johnnei.javatorrent.bittorrent.protocol.messages.MessageUninterested;

public class MessageFactory {
    private final Map<Integer, Supplier<IMessage>> messageSuppliers;

    private MessageFactory(Builder builder) {
        this.messageSuppliers = builder.messageSuppliers;
    }

    public IMessage createById(int id) {
        if (!this.messageSuppliers.containsKey(id)) {
            throw new IllegalArgumentException(String.format("Message %d is not known.", id));
        }
        return this.messageSuppliers.get(id).get();
    }

    public static class Builder {
        private Map<Integer, Supplier<IMessage>> messageSuppliers = new HashMap<Integer, Supplier<IMessage>>();

        public Builder() {
            this.registerMessage(5, MessageBitfield::new);
            this.registerMessage(8, MessageCancel::new);
            this.registerMessage(0, MessageChoke::new);
            this.registerMessage(4, MessageHave::new);
            this.registerMessage(2, MessageInterested::new);
            this.registerMessage(7, MessageBlock::new);
            this.registerMessage(6, MessageRequest::new);
            this.registerMessage(1, MessageUnchoke::new);
            this.registerMessage(3, MessageUninterested::new);
        }

        public Builder registerMessage(int id, Supplier<IMessage> messageSupplier) {
            if (this.messageSuppliers.containsKey(id)) {
                throw new IllegalStateException(String.format("Failed to add message with id %d: Already taken.", id));
            }
            this.messageSuppliers.put(id, messageSupplier);
            return this;
        }

        public MessageFactory build() {
            return new MessageFactory(this);
        }
    }
}

