/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.bittorrent.protocol.messages;

import java.time.Duration;
import java.util.Optional;
import org.johnnei.javatorrent.bittorrent.protocol.messages.IMessage;
import org.johnnei.javatorrent.network.InStream;
import org.johnnei.javatorrent.network.OutStream;
import org.johnnei.javatorrent.torrent.TorrentFileSet;
import org.johnnei.javatorrent.torrent.peer.Peer;

public class MessageBlock
implements IMessage {
    private int index;
    private int offset;
    private byte[] data;
    private Duration readDuration;

    public MessageBlock() {
    }

    public MessageBlock(int index, int offset, byte[] data) {
        this.index = index;
        this.offset = offset;
        this.data = data;
    }

    @Override
    public void write(OutStream outStream) {
        outStream.writeInt(this.index);
        outStream.writeInt(this.offset);
        outStream.write(this.data);
    }

    @Override
    public void read(InStream inStream) {
        this.index = inStream.readInt();
        this.offset = inStream.readInt();
        this.data = inStream.readFully(inStream.available());
        this.readDuration = inStream.getReadDuration().orElse(null);
    }

    @Override
    public void process(Peer peer) {
        TorrentFileSet torrentFileSet = peer.getTorrent().getFileSet();
        peer.onReceivedBlock(torrentFileSet.getPiece(this.index), this.offset);
        if (this.data.length <= 0) {
            peer.addStrike(1);
            return;
        }
        peer.getTorrent().onReceivedBlock(torrentFileSet, this.index, this.offset, this.data);
        peer.getTorrent().getRequestLimiter().onReceivedBlock(peer, this);
        peer.addStrike(-1);
    }

    @Override
    public int getLength() {
        return 9 + this.data.length;
    }

    @Override
    public int getId() {
        return 7;
    }

    public String toString() {
        return String.format("MessageBlock[index=%d, offset=%d, length=%d]", this.index, this.offset, this.data != null ? this.data.length : -1);
    }

    public Optional<Duration> getReadDuration() {
        return Optional.ofNullable(this.readDuration);
    }
}

