/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.bittorrent.tracker;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.johnnei.javatorrent.TorrentClient;
import org.johnnei.javatorrent.bittorrent.tracker.ITracker;
import org.johnnei.javatorrent.bittorrent.tracker.TrackerException;
import org.johnnei.javatorrent.torrent.Torrent;
import org.johnnei.javatorrent.utils.CheckedBiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(TrackerFactory.class);
    private final Map<String, ITracker> trackerInstances;
    private final Map<String, CheckedBiFunction<String, TorrentClient, ITracker, TrackerException>> trackerSuppliers;
    private final TorrentClient torrentClient;

    private TrackerFactory(Builder builder) {
        this.trackerSuppliers = builder.trackerSuppliers;
        this.torrentClient = builder.torrentClient;
        this.trackerInstances = new HashMap<String, ITracker>();
    }

    public Optional<ITracker> getTrackerFor(String trackerUrl) {
        if (this.trackerInstances.containsKey(trackerUrl)) {
            return Optional.of(this.trackerInstances.get(trackerUrl));
        }
        if (!trackerUrl.contains("://")) {
            throw new IllegalArgumentException(String.format("Missing protocol definition in: %s", trackerUrl));
        }
        String[] trackerParts = trackerUrl.split("://", 2);
        String protocol = trackerParts[0];
        if (!this.trackerSuppliers.containsKey(protocol)) {
            LOGGER.warn("Unsupported protocol: {}", (Object)protocol);
            return Optional.empty();
        }
        try {
            ITracker tracker = this.trackerSuppliers.get(protocol).apply(trackerUrl, this.torrentClient);
            this.trackerInstances.put(trackerUrl, tracker);
            return Optional.of(tracker);
        }
        catch (TrackerException e) {
            LOGGER.warn("Failed create new tracker for url: {}", (Object)trackerUrl, (Object)e);
            return Optional.empty();
        }
    }

    public List<ITracker> getTrackersHavingTorrent(Torrent torrent) {
        return this.trackerInstances.values().stream().filter(tracker -> tracker.hasTorrent(torrent)).collect(Collectors.toList());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("TrackerFactory[");
        stringBuilder.append("protocols=[");
        stringBuilder.append(this.trackerSuppliers.keySet().stream().reduce((a, b) -> a + ", " + b).orElse(""));
        stringBuilder.append("], instances=[");
        stringBuilder.append(this.trackerInstances.keySet().stream().reduce((a, b) -> a + ", " + b).orElse(""));
        stringBuilder.append("]]");
        return stringBuilder.toString();
    }

    public static class Builder {
        private Map<String, CheckedBiFunction<String, TorrentClient, ITracker, TrackerException>> trackerSuppliers = new HashMap<String, CheckedBiFunction<String, TorrentClient, ITracker, TrackerException>>();
        private TorrentClient torrentClient;

        public Builder registerProtocol(String protocol, CheckedBiFunction<String, TorrentClient, ITracker, TrackerException> supplier) {
            if (this.trackerSuppliers.containsKey(protocol)) {
                LOGGER.warn(String.format("Overriding existing %s protocol implementation", protocol));
            }
            this.trackerSuppliers.put(protocol, supplier);
            return this;
        }

        public Builder setTorrentClient(TorrentClient torrentClient) {
            this.torrentClient = torrentClient;
            return this;
        }

        public TrackerFactory build() {
            if (this.trackerSuppliers.isEmpty()) {
                throw new IllegalStateException("At least one tracker protocol must be configured.");
            }
            if (this.torrentClient == null) {
                throw new IllegalStateException("Torrent client must be set");
            }
            return new TrackerFactory(this);
        }
    }
}

