/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.disk;

import java.io.IOException;
import java.util.function.Consumer;
import org.johnnei.javatorrent.disk.IDiskJob;
import org.johnnei.javatorrent.internal.disk.DiskJobPriority;
import org.johnnei.javatorrent.torrent.files.Piece;

public class DiskJobCheckHash
implements IDiskJob {
    private final Piece piece;
    private final Consumer<DiskJobCheckHash> callback;
    private boolean matchingHash;

    public DiskJobCheckHash(Piece piece, Consumer<DiskJobCheckHash> callback) {
        this.callback = callback;
        this.piece = piece;
    }

    @Override
    public void process() throws IOException {
        this.matchingHash = this.piece.checkHash();
        this.callback.accept(this);
    }

    @Override
    public int getPriority() {
        return DiskJobPriority.LOCAL_ACTION.getPriority();
    }

    public boolean isMatchingHash() {
        return this.matchingHash;
    }

    public Piece getPiece() {
        return this.piece;
    }

    public String toString() {
        return String.format("DiskJobCheckHash[piece=%d]", this.piece.getIndex());
    }
}

