/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.disk;

import java.io.IOException;
import java.util.function.Consumer;
import org.johnnei.javatorrent.disk.IDiskJob;
import org.johnnei.javatorrent.internal.disk.DiskJobPriority;
import org.johnnei.javatorrent.torrent.files.Piece;

public class DiskJobReadBlock
implements IDiskJob {
    private final Consumer<DiskJobReadBlock> callback;
    private final Piece piece;
    private final int offset;
    private final int length;
    private byte[] blockData;

    public DiskJobReadBlock(Piece piece, int offset, int length, Consumer<DiskJobReadBlock> callback) {
        this.callback = callback;
        this.piece = piece;
        this.offset = offset;
        this.length = length;
    }

    @Override
    public void process() throws IOException {
        this.blockData = this.piece.loadPiece(this.offset, this.length);
        this.callback.accept(this);
    }

    @Override
    public int getPriority() {
        return DiskJobPriority.OUTGOING_DATA.getPriority();
    }

    public byte[] getBlockData() {
        return this.blockData;
    }

    public Piece getPiece() {
        return this.piece;
    }

    public int getOffset() {
        return this.offset;
    }

    public String toString() {
        return String.format("DiskJobReadBlock[piece=%d, offset=%d, length=%d]", this.piece.getIndex(), this.offset, this.length);
    }
}

