/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.internal.disk;

import java.util.PriorityQueue;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.johnnei.javatorrent.disk.IDiskJob;
import org.johnnei.javatorrent.internal.disk.DiskJobWrapper;
import org.johnnei.javatorrent.internal.utils.Sync;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOManager
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(IOManager.class);
    private final Lock lock;
    private final Condition newTaskEvent;
    private PriorityQueue<DiskJobWrapper> taskQueue = new PriorityQueue();

    public IOManager() {
        this.lock = new ReentrantLock();
        this.newTaskEvent = this.lock.newCondition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(IDiskJob task) {
        IOManager iOManager = this;
        synchronized (iOManager) {
            this.taskQueue.add(new DiskJobWrapper(task));
        }
        Sync.signalAll(this.lock, this.newTaskEvent);
    }

    private boolean awaitTask() {
        while (this.taskQueue.isEmpty()) {
            try {
                this.lock.lock();
                this.newTaskEvent.await();
            }
            catch (InterruptedException e) {
                LOGGER.info("IO Manager was interrupted. Stopping thread.", (Throwable)e);
                boolean bl = false;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTasks() {
        while (!this.taskQueue.isEmpty()) {
            DiskJobWrapper task;
            IOManager iOManager = this;
            synchronized (iOManager) {
                task = (DiskJobWrapper)this.taskQueue.remove();
            }
            LOGGER.trace("Processing task: {}", (Object)task);
            if (task.process()) continue;
            iOManager = this;
            synchronized (iOManager) {
                this.taskQueue.add(task);
            }
        }
    }

    @Override
    public void run() {
        if (!this.awaitTask()) {
            return;
        }
        this.processTasks();
    }
}

