/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.internal.network;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.johnnei.javatorrent.bittorrent.protocol.BitTorrentProtocolViolationException;
import org.johnnei.javatorrent.bittorrent.protocol.messages.IMessage;
import org.johnnei.javatorrent.network.BitTorrentSocket;
import org.johnnei.javatorrent.network.socket.ISocket;
import org.johnnei.javatorrent.torrent.peer.Peer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class PeerIoHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(PeerIoHandler.class);
    private final ScheduledFuture<?> task;
    private final Selector selector;

    public PeerIoHandler(ScheduledExecutorService scheduledExecutorService) {
        try {
            this.selector = Selector.open();
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create async selector.", e);
        }
        this.task = scheduledExecutorService.scheduleWithFixedDelay(this::pollChannels, 50L, 50L, TimeUnit.MILLISECONDS);
    }

    public void registerPeer(Peer peer, ISocket socket) {
        try {
            if ((((SelectableChannel)socket.getReadableChannel()).validOps() & 4) != 0) {
                ((SelectableChannel)socket.getReadableChannel()).register(this.selector, 5, peer);
            } else {
                ((SelectableChannel)socket.getReadableChannel()).register(this.selector, 1, peer);
                ((SelectableChannel)socket.getWritableChannel()).register(this.selector, 4, peer);
            }
        }
        catch (ClosedChannelException e) {
            throw new IllegalStateException("Channel mustn't be closed to be handled.", e);
        }
    }

    public void shutdown() {
        this.task.cancel(false);
    }

    public void pollChannels() {
        try {
            this.selector.selectNow();
            Iterator<SelectionKey> keys = this.selector.selectedKeys().iterator();
            while (keys.hasNext()) {
                SelectionKey key = keys.next();
                Peer peer = (Peer)key.attachment();
                this.handlePeer(key, peer);
                keys.remove();
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to process ready channels.", (Throwable)e);
        }
    }

    public void handlePeer(SelectionKey key, Peer peer) {
        try (MDC.MDCCloseable ignored = MDC.putCloseable((String)"context", (String)peer.getIdAsString());){
            BitTorrentSocket socket = peer.getBitTorrentSocket();
            try {
                if (key.isReadable()) {
                    this.onDataAvailable(peer, socket);
                }
                if (key.isWritable()) {
                    this.onDataRequested(peer, socket);
                }
            }
            catch (IOException e) {
                LOGGER.info("Failed to process peer.", (Throwable)e);
                socket.close();
            }
        }
    }

    private void onDataAvailable(Peer peer, BitTorrentSocket socket) throws IOException {
        try {
            while (socket.canReadMessage()) {
                IMessage message = socket.readMessage();
                message.process(peer);
            }
        }
        catch (BitTorrentProtocolViolationException e) {
            throw new IOException(String.format("Peer %s violated protocol", peer), e);
        }
    }

    private void onDataRequested(Peer peer, BitTorrentSocket socket) throws IOException {
        if (socket.hasOutboundMessages()) {
            socket.sendMessages();
        } else {
            peer.queueNextPieceForSending();
        }
    }
}

