/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.internal.network;

import java.time.Clock;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.concurrent.atomic.AtomicInteger;

public class TransferRate {
    private final Clock clock;
    private LocalDateTime lastPoll;
    private AtomicInteger transferredBytes;
    private int rate;

    public TransferRate(Clock clock) {
        this.clock = clock;
        this.transferredBytes = new AtomicInteger(0);
        this.lastPoll = LocalDateTime.now(clock);
    }

    public void addTransferredBytes(int count) {
        this.transferredBytes.addAndGet(count);
    }

    public void pollRate() {
        int bytes = this.transferredBytes.getAndSet(0);
        LocalDateTime now = LocalDateTime.now(this.clock);
        Duration pollDuration = Duration.between(this.lastPoll, now);
        this.rate = (int)((long)bytes * 1000L / Math.max(1L, pollDuration.toMillis()));
    }

    public int getRate() {
        return this.rate;
    }
}

