/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.internal.network.connector;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.WritableByteChannel;
import java.time.Clock;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.johnnei.javatorrent.TorrentClient;
import org.johnnei.javatorrent.bittorrent.protocol.BitTorrentProtocolViolationException;
import org.johnnei.javatorrent.internal.network.PeerIoHandler;
import org.johnnei.javatorrent.internal.network.connector.HandshakeState;
import org.johnnei.javatorrent.network.BitTorrentSocket;
import org.johnnei.javatorrent.network.ByteBufferUtils;
import org.johnnei.javatorrent.network.connector.BitTorrentHandshakeHandler;
import org.johnnei.javatorrent.network.socket.ISocket;
import org.johnnei.javatorrent.torrent.Torrent;
import org.johnnei.javatorrent.torrent.peer.Peer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitTorrentHandshakeHandlerImpl
implements BitTorrentHandshakeHandler {
    public static final int HANDSHAKE_SIZE = 68;
    public static final String PROTOCOL_NAME = "BitTorrent protocol";
    public static final int PROTOCOL_LENGTH = "BitTorrent protocol".length();
    private static final Logger LOGGER = LoggerFactory.getLogger(BitTorrentHandshakeHandlerImpl.class);
    private static final int TORRENT_HASH_OFFSET = 28;
    private final ByteBuffer bittorrentHandshake = ByteBuffer.allocate(68);
    private final TorrentClient torrentClient;
    private final Clock clock;
    private final Selector selector;
    private final PeerIoHandler peerIoHandler;
    private final ScheduledFuture<?> poller;

    public BitTorrentHandshakeHandlerImpl(TorrentClient torrentClient, PeerIoHandler peerIoHandler) {
        this(torrentClient, peerIoHandler, Clock.systemDefaultZone());
    }

    BitTorrentHandshakeHandlerImpl(TorrentClient torrentClient, PeerIoHandler peerIoHandler, Clock clock) {
        this.torrentClient = torrentClient;
        this.clock = clock;
        this.peerIoHandler = peerIoHandler;
        this.bittorrentHandshake.put((byte)19);
        ByteBufferUtils.putString(this.bittorrentHandshake, PROTOCOL_NAME);
        this.bittorrentHandshake.put(torrentClient.getExtensionBytes());
        this.bittorrentHandshake.position(this.bittorrentHandshake.position() + 20);
        this.bittorrentHandshake.put(torrentClient.getPeerId());
        try {
            this.selector = Selector.open();
        }
        catch (IOException e) {
            throw new IllegalStateException("NIO is not available", e);
        }
        this.poller = torrentClient.getExecutorService().scheduleWithFixedDelay(this::pollHandshakesReady, 50L, 50L, TimeUnit.MILLISECONDS);
    }

    @Override
    public synchronized void onConnectionEstablished(ISocket socket, byte[] torrentHash) {
        try {
            this.sendHandshake((WritableByteChannel)socket.getWritableChannel(), torrentHash);
        }
        catch (IOException e) {
            LOGGER.debug("Failed to send handshake", (Throwable)e);
            this.close(socket);
            return;
        }
        try {
            HandshakeState state = new HandshakeState(this.clock, socket, torrentHash);
            ((SelectableChannel)socket.getReadableChannel()).register(this.selector, 1, state);
        }
        catch (ClosedChannelException e) {
            throw new IllegalStateException("Attempted to connect to peer on closed selector.", e);
        }
    }

    private void close(ISocket socket) {
        try {
            socket.close();
        }
        catch (IOException ce) {
            LOGGER.warn("Failed to close channel.", (Throwable)ce);
        }
    }

    @Override
    public synchronized void onConnectionReceived(ISocket socket) {
        try {
            LOGGER.debug("Expecting handshake from: {}", (Object)socket);
            HandshakeState state = new HandshakeState(this.clock, socket, null);
            ((SelectableChannel)socket.getReadableChannel()).register(this.selector, 1, state);
        }
        catch (ClosedChannelException e) {
            throw new IllegalStateException("Attempted to connect to peer on closed selector.", e);
        }
    }

    public void stop() {
        this.selector.wakeup();
        try {
            this.selector.close();
        }
        catch (IOException e) {
            LOGGER.warn("Error during shutdown of selector", (Throwable)e);
        }
        this.poller.cancel(false);
    }

    private void sendHandshake(WritableByteChannel channel, byte[] torrentHash) throws IOException {
        this.bittorrentHandshake.position(28);
        this.bittorrentHandshake.put(torrentHash);
        this.bittorrentHandshake.position(this.bittorrentHandshake.capacity());
        this.bittorrentHandshake.flip();
        channel.write(this.bittorrentHandshake);
        if (this.bittorrentHandshake.hasRemaining()) {
            throw new IOException("Socket buffer exceeded.");
        }
    }

    private synchronized void pollHandshakesReady() {
        ReadableByteChannel channel;
        HandshakeState state;
        try {
            this.selector.selectNow();
            Iterator<SelectionKey> keys = this.selector.selectedKeys().iterator();
            while (keys.hasNext()) {
                SelectionKey key = keys.next();
                state = (HandshakeState)key.attachment();
                channel = (ReadableByteChannel)((Object)key.channel());
                this.handlePeer(key, state, channel);
                keys.remove();
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to select channels.", (Throwable)e);
        }
        for (SelectionKey key : this.selector.keys()) {
            state = (HandshakeState)key.attachment();
            channel = (ReadableByteChannel)((Object)key.channel());
            if (!this.clock.instant().minusSeconds(5L).isAfter(state.getConnectionStart())) continue;
            LOGGER.debug("Handshake timed out for {} missing {} bytes.", (Object)channel, (Object)state.getHandshakeBuffer().remaining());
            this.close(state.getSocket());
        }
    }

    private void handlePeer(SelectionKey key, HandshakeState state, ReadableByteChannel channel) {
        try {
            channel.read(state.getHandshakeBuffer());
            if (!state.getHandshakeBuffer().hasRemaining()) {
                this.onHandshakeReceived(key, state);
            }
        }
        catch (Exception e) {
            LOGGER.debug("Failed to process peer handshake.", (Throwable)e);
            this.close(state.getSocket());
        }
    }

    private void onHandshakeReceived(SelectionKey key, HandshakeState state) throws IOException {
        Torrent torrent;
        ByteBuffer buffer = state.getHandshakeBuffer();
        buffer.flip();
        byte length = buffer.get();
        if (length != PROTOCOL_LENGTH) {
            throw new BitTorrentProtocolViolationException("Incorrect handshake length");
        }
        String protocol = ByteBufferUtils.getString(buffer, 19);
        if (!PROTOCOL_NAME.equals(protocol)) {
            throw new BitTorrentProtocolViolationException("Incorrect protocol");
        }
        byte[] extensionBytes = ByteBufferUtils.getBytes(buffer, 8);
        byte[] torrentHash = ByteBufferUtils.getBytes(buffer, 20);
        if (state.getExpectedTorrent() == null) {
            torrent = this.torrentClient.getTorrentByHash(torrentHash).orElseThrow(() -> new BitTorrentProtocolViolationException("Remote peer is downloading torrent we don't have."));
            this.sendHandshake((WritableByteChannel)state.getSocket().getWritableChannel(), torrentHash);
        } else {
            if (!Arrays.equals(state.getExpectedTorrent(), torrentHash)) {
                throw new BitTorrentProtocolViolationException("Remote peer reported different torrent than requested.");
            }
            torrent = this.torrentClient.getTorrentByHash(state.getExpectedTorrent()).orElseThrow(() -> new BitTorrentProtocolViolationException("We requested a torrent from the remote peer which we no longer have."));
        }
        byte[] receivedPeerId = ByteBufferUtils.getBytes(buffer, 20);
        Peer peer = new Peer.Builder().setId(receivedPeerId).setExtensionBytes(extensionBytes).setTorrent(torrent).setSocket(new BitTorrentSocket(this.torrentClient.getMessageFactory(), state.getSocket())).build();
        torrent.addPeer(peer);
        this.peerIoHandler.registerPeer(peer, state.getSocket());
        key.cancel();
    }
}

