/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.internal.network.connector;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.johnnei.javatorrent.TorrentClient;
import org.johnnei.javatorrent.network.socket.NioTcpSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NioConnectionAcceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(NioConnectionAcceptor.class);
    private final TorrentClient torrentClient;
    private final ServerSocketChannel serverChannel;
    private final ScheduledFuture<?> poller;

    public NioConnectionAcceptor(TorrentClient torrentClient) {
        this.torrentClient = torrentClient;
        try {
            this.serverChannel = ServerSocketChannel.open();
            this.serverChannel.bind(new InetSocketAddress(torrentClient.getDownloadPort()));
            this.serverChannel.configureBlocking(false);
            this.poller = torrentClient.getExecutorService().scheduleWithFixedDelay(this::pollConnections, 50L, 100L, TimeUnit.MILLISECONDS);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to set up Nio socket listener.", e);
        }
        LOGGER.info("Listening for incoming peer on TCP port {}", (Object)torrentClient.getDownloadPort());
    }

    public void stop() {
        this.poller.cancel(false);
    }

    private void pollConnections() {
        try {
            SocketChannel channel;
            while ((channel = this.serverChannel.accept()) != null) {
                channel.configureBlocking(false);
                NioTcpSocket socket = new NioTcpSocket(channel);
                LOGGER.debug("Received connecting from {} with socket type {}", (Object)socket, (Object)socket.getClass().getSimpleName());
                this.torrentClient.getHandshakeHandler().onConnectionReceived(socket);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to accept connection", (Throwable)e);
        }
    }
}

