/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.internal.torrent;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.johnnei.javatorrent.TorrentClient;
import org.johnnei.javatorrent.internal.network.connector.NioConnectionAcceptor;
import org.johnnei.javatorrent.internal.torrent.TorrentProcessor;
import org.johnnei.javatorrent.internal.tracker.TrackerManager;
import org.johnnei.javatorrent.torrent.Torrent;

public class TorrentManager {
    private final Object torrentListLock = new Object();
    private TorrentClient torrentClient;
    private TrackerManager trackerManager;
    private List<TorrentPair> activeTorrents;
    private NioConnectionAcceptor connectionAcceptor;

    public TorrentManager(TrackerManager trackerManager) {
        this.trackerManager = trackerManager;
        this.activeTorrents = new ArrayList<TorrentPair>();
    }

    public void start(TorrentClient torrentClient) {
        this.torrentClient = torrentClient;
    }

    public void enableConnectionAcceptor() {
        this.connectionAcceptor = new NioConnectionAcceptor(this.torrentClient);
    }

    public void stop() {
        if (this.connectionAcceptor != null) {
            this.connectionAcceptor.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTorrent(Torrent torrent) {
        Object object = this.torrentListLock;
        synchronized (object) {
            this.activeTorrents.add(new TorrentPair(this, this.trackerManager, this.torrentClient, torrent));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTorrent(Torrent torrent) {
        Object object = this.torrentListLock;
        synchronized (object) {
            this.activeTorrents.removeIf(torrentPair -> torrentPair.getTorrent().equals(torrent));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownTorrent(Torrent torrent) {
        Optional<TorrentPair> pair;
        Object object = this.torrentListLock;
        synchronized (object) {
            pair = this.activeTorrents.stream().filter(torrentPair -> torrentPair.getTorrent().equals(torrent)).findAny();
            if (pair.isPresent()) {
                this.activeTorrents.remove(pair.get());
            }
        }
        if (pair.isPresent()) {
            pair.get().getTorrentProcessor().shutdownTorrent();
        }
    }

    public Optional<Torrent> getTorrent(byte[] hash) {
        return this.activeTorrents.stream().map(TorrentPair::getTorrent).filter(torrent -> Arrays.equals(torrent.getMetadata().getHash(), hash)).findAny();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Torrent> getTorrents() {
        Object object = this.torrentListLock;
        synchronized (object) {
            return this.activeTorrents.stream().map(TorrentPair::getTorrent).collect(Collectors.toList());
        }
    }

    private final class TorrentPair {
        private final Torrent torrent;
        private final TorrentProcessor torrentProcessor;

        TorrentPair(TorrentManager torrentManager2, TrackerManager trackerManager, TorrentClient torrentClient, Torrent torrent) {
            this.torrent = torrent;
            this.torrentProcessor = new TorrentProcessor(torrentManager2, trackerManager, torrentClient, torrent);
        }

        public Torrent getTorrent() {
            return this.torrent;
        }

        public TorrentProcessor getTorrentProcessor() {
            return this.torrentProcessor;
        }
    }
}

