/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.internal.torrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.johnnei.javatorrent.TorrentClient;
import org.johnnei.javatorrent.internal.torrent.TorrentManager;
import org.johnnei.javatorrent.internal.tracker.TrackerManager;
import org.johnnei.javatorrent.phases.IDownloadPhase;
import org.johnnei.javatorrent.torrent.Torrent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TorrentProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TorrentProcessor.class);
    private final TorrentManager torrentManager;
    private final TorrentClient torrentClient;
    private final TrackerManager trackerManager;
    private final Torrent torrent;
    private IDownloadPhase downloadPhase;
    private Collection<ScheduledFuture<?>> scheduledTasks;

    public TorrentProcessor(TorrentManager torrentManager, TrackerManager trackerManager, TorrentClient torrentClient, Torrent torrent) {
        this.torrentManager = torrentManager;
        this.trackerManager = trackerManager;
        this.torrentClient = torrentClient;
        this.torrent = torrent;
        this.scheduledTasks = new ArrayList(3);
        this.downloadPhase = torrentClient.getPhaseRegulator().createInitialPhase(torrentClient, torrent);
        this.downloadPhase.onPhaseEnter();
        this.scheduledTasks.add(torrentClient.getExecutorService().scheduleAtFixedRate(this::updateTorrentState, 0L, 250L, TimeUnit.MILLISECONDS));
        this.scheduledTasks.add(torrentClient.getExecutorService().scheduleAtFixedRate(this::updateChokingStates, 1L, 10L, TimeUnit.SECONDS));
        this.scheduledTasks.add(torrentClient.getExecutorService().scheduleAtFixedRate(this::removeDisconnectedPeers, 30L, 60L, TimeUnit.SECONDS));
        this.scheduledTasks.add(torrentClient.getExecutorService().scheduleAtFixedRate(this::updateTrackerStates, 10L, 30L, TimeUnit.SECONDS));
    }

    public void updateTrackerStates() {
        this.trackerManager.announce(this.torrent);
    }

    public void removeDisconnectedPeers() {
        this.torrent.getPeers().stream().filter(p -> p.getBitTorrentSocket().closed()).forEach(this.torrent::removePeer);
    }

    public void updateChokingStates() {
        this.torrent.getPeers().forEach(this.downloadPhase.getChokingStrategy()::updateChoking);
    }

    public void updateTorrentState() {
        try {
            if (this.downloadPhase.isDone()) {
                this.downloadPhase.onPhaseExit();
                Optional<IDownloadPhase> newPhase = this.torrentClient.getPhaseRegulator().createNextPhase(this.downloadPhase, this.torrentClient, this.torrent);
                if (newPhase.isPresent()) {
                    LOGGER.info("Torrent transitioning from {} to {}", (Object)this.downloadPhase, (Object)newPhase.get());
                    this.downloadPhase = newPhase.get();
                    this.downloadPhase.onPhaseEnter();
                } else {
                    LOGGER.info("Torrent ended from {}", (Object)this.downloadPhase);
                    this.shutdownTorrent();
                    return;
                }
            }
            this.downloadPhase.process();
        }
        catch (Exception e) {
            LOGGER.error("Failed to update torrent state", (Throwable)e);
            this.shutdownTorrent();
        }
    }

    public void shutdownTorrent() {
        for (ScheduledFuture<?> task : this.scheduledTasks) {
            task.cancel(false);
        }
        this.torrentManager.removeTorrent(this.torrent);
    }
}

