/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.internal.torrent.peer;

import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class Bitfield {
    private ReadWriteLock resizeLock;
    private byte[] bitfieldBytes;

    public Bitfield(int size) {
        this.bitfieldBytes = new byte[size];
        this.resizeLock = new ReentrantReadWriteLock();
    }

    public void setSize(int size) {
        this.resizeLock.readLock().lock();
        if (size == this.bitfieldBytes.length) {
            this.resizeLock.readLock().unlock();
            return;
        }
        this.resizeLock.readLock().unlock();
        this.resizeLock.writeLock().lock();
        byte[] newBitfield = new byte[size];
        System.arraycopy(this.bitfieldBytes, 0, newBitfield, 0, Math.min(size, this.bitfieldBytes.length));
        this.bitfieldBytes = newBitfield;
        this.resizeLock.writeLock().unlock();
    }

    public boolean hasPiece(int pieceIndex) {
        int byteIndex = pieceIndex / 8;
        int bit = pieceIndex % 8;
        this.resizeLock.readLock().lock();
        if (byteIndex < this.bitfieldBytes.length) {
            int bitVal = 128 >> bit;
            boolean isSet = (this.bitfieldBytes[byteIndex] & bitVal) > 0;
            this.resizeLock.readLock().unlock();
            return isSet;
        }
        this.resizeLock.readLock().unlock();
        return false;
    }

    public void havePiece(int pieceIndex) {
        this.havePiece(pieceIndex, false);
    }

    public void havePiece(int pieceIndex, boolean mayExpand) {
        int byteIndex = pieceIndex / 8;
        int bit = pieceIndex % 8;
        this.resizeLock.readLock().lock();
        if (byteIndex >= this.bitfieldBytes.length) {
            if (mayExpand) {
                this.resizeLock.readLock().unlock();
                this.setSize(byteIndex + 1);
                this.resizeLock.readLock().lock();
            } else {
                return;
            }
        }
        int n = byteIndex;
        this.bitfieldBytes[n] = (byte)(this.bitfieldBytes[n] | 128 >> bit);
        this.resizeLock.readLock().unlock();
    }

    public byte[] getBytes() {
        this.resizeLock.readLock().lock();
        byte[] clone = (byte[])this.bitfieldBytes.clone();
        this.resizeLock.readLock().unlock();
        return clone;
    }

    public int countHavePieces() {
        this.resizeLock.readLock().lock();
        int pieces = this.bitfieldBytes.length * 8;
        int have = 0;
        for (int pieceIndex = 0; pieceIndex < pieces; ++pieceIndex) {
            if (!this.hasPiece(pieceIndex)) continue;
            ++have;
        }
        this.resizeLock.readLock().unlock();
        return have;
    }
}

