/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.internal.torrent.peer;

import java.util.Objects;
import org.johnnei.javatorrent.torrent.files.Piece;

public class Job {
    private Piece piece;
    private int block;
    private int length;

    public Job(Piece piece, int blockIndex, int length) {
        this.piece = Objects.requireNonNull(piece);
        this.block = blockIndex;
        this.length = length;
    }

    public Piece getPiece() {
        return this.piece;
    }

    public int getBlockIndex() {
        return this.block;
    }

    public int getLength() {
        return this.length;
    }

    public int hashCode() {
        return Objects.hash(this.piece, this.block, this.length);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Job)) {
            return false;
        }
        Job other = (Job)obj;
        if (!Objects.equals(this.piece, other.piece)) {
            return false;
        }
        if (this.block != other.block) {
            return false;
        }
        return this.length == other.length;
    }

    public String toString() {
        return String.format("Job[piece=%s, block=%d, length=%d]", this.piece, this.block, this.length);
    }
}

