/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.internal.tracker.http;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.time.Clock;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.johnnei.javatorrent.TorrentClient;
import org.johnnei.javatorrent.bittorrent.encoding.BencodedList;
import org.johnnei.javatorrent.bittorrent.encoding.BencodedMap;
import org.johnnei.javatorrent.bittorrent.encoding.Bencoding;
import org.johnnei.javatorrent.bittorrent.encoding.IBencodedValue;
import org.johnnei.javatorrent.bittorrent.tracker.ITracker;
import org.johnnei.javatorrent.bittorrent.tracker.TorrentInfo;
import org.johnnei.javatorrent.bittorrent.tracker.TrackerEvent;
import org.johnnei.javatorrent.internal.tracker.http.TrackerUrl;
import org.johnnei.javatorrent.network.InStream;
import org.johnnei.javatorrent.network.PeerConnectInfo;
import org.johnnei.javatorrent.torrent.Torrent;
import org.johnnei.javatorrent.utils.Argument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpTracker
implements ITracker {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpTracker.class);
    private static final String STATE_ANNOUNCING = "Announcing";
    private static final String STATE_ANNOUNCE_ERROR = "Announce failed";
    private static final String STATE_IDLE = "Idle";
    private final Clock clock = Clock.systemDefaultZone();
    private final TorrentClient torrentClient;
    private final TrackerUrl trackerUrl;
    private final OkHttpClient httpClient;
    private final Bencoding bencoding;
    private Map<Torrent, TorrentInfo> torrentMap;
    private long announceInterval = 30000L;
    private String status;

    public HttpTracker(Builder builder) {
        this.torrentClient = Argument.requireNonNull(builder.torrentClient, "Torrent Client must be provided");
        this.trackerUrl = new TrackerUrl(Argument.requireNonNull(builder.trackerUrl, "Tracker Url must be provided"));
        this.httpClient = new OkHttpClient();
        this.torrentMap = new HashMap<Torrent, TorrentInfo>();
        this.bencoding = new Bencoding();
        this.status = STATE_IDLE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void announce(Torrent torrent) {
        TorrentInfo torrentInfo;
        HttpTracker httpTracker = this;
        synchronized (httpTracker) {
            torrentInfo = this.torrentMap.get(torrent);
        }
        if (torrentInfo.getTimeSinceLastAnnounce().compareTo(Duration.of(this.announceInterval, ChronoUnit.MILLIS)) < 0) {
            return;
        }
        HttpUrl.Builder urlBuilder = new HttpUrl.Builder().scheme(this.trackerUrl.getSchema()).host(this.trackerUrl.getHost()).port(this.trackerUrl.getPort()).addPathSegments(this.trackerUrl.getPath()).addEncodedQueryParameter("info_hash", this.hexEncode(torrent.getMetadata().getHash())).addEncodedQueryParameter("peer_id", this.hexEncode(this.torrentClient.getPeerId())).addQueryParameter("port", Integer.toUnsignedString(this.torrentClient.getDownloadPort())).addQueryParameter("uploaded", Long.toString(torrent.getUploadedBytes())).addQueryParameter("downloaded", Long.toString(torrent.getDownloadedBytes())).addQueryParameter("compact", "0");
        if (torrent.getFileSet() != null) {
            urlBuilder.addQueryParameter("left", Long.toString(torrent.getFileSet().countRemainingBytes()));
        } else {
            urlBuilder.addQueryParameter("left", "0");
        }
        TorrentInfo info = this.torrentMap.get(torrent);
        TrackerEvent event = info.getEvent();
        if (event != TrackerEvent.EVENT_NONE) {
            info.setEvent(TrackerEvent.EVENT_NONE);
            urlBuilder.addQueryParameter("event", event.getTextual());
        }
        Request request = new Request.Builder().url(urlBuilder.build()).build();
        this.torrentClient.getExecutorService().submit(() -> this.doAnnounce(torrent, request));
    }

    private void doAnnounce(Torrent torrent, Request request) {
        try {
            this.status = STATE_ANNOUNCING;
            LOGGER.debug("Sending query: {}", (Object)request);
            Response response = this.httpClient.newCall(request).execute();
            InStream inStream = new InStream(response.body().bytes());
            BencodedMap result = (BencodedMap)this.bencoding.decode(inStream);
            LOGGER.debug("Query response: {}", result.asMap());
            Optional<IBencodedValue> failure = result.get("failure reason");
            if (failure.isPresent()) {
                this.status = STATE_ANNOUNCE_ERROR;
                LOGGER.error("Tracker returned \"{}\" for announce: {}", (Object)failure.get(), (Object)request);
                return;
            }
            result.get("interval").ifPresent(interval -> {
                this.announceInterval = interval.asLong();
            });
            result.get("peers").ifPresent(peers -> this.processPeers(torrent, (IBencodedValue)peers));
            this.torrentMap.get(torrent).setInfo(0, 0);
            this.status = STATE_IDLE;
        }
        catch (IOException e) {
            this.status = STATE_ANNOUNCE_ERROR;
            LOGGER.warn("Announce failed with error", (Throwable)e);
        }
    }

    private void processPeers(Torrent torrent, IBencodedValue peers) {
        if (!(peers instanceof BencodedList)) {
            LOGGER.warn(String.format("Tracker \"%s\" returned peers list in an unsupported format. (Most likely BEP #23 is not configured).", this.trackerUrl.getHost()));
            return;
        }
        peers.asList().stream().map(entry -> (BencodedMap)entry).forEach(peer -> {
            LOGGER.debug("Received peer: {}", peer);
            Optional<IBencodedValue> hostname = peer.get("ip");
            Optional<IBencodedValue> port = peer.get("port");
            if (!hostname.isPresent() || !port.isPresent()) {
                LOGGER.warn(String.format("Tracker \"%s\" returned incomplete peer entry.", this.trackerUrl.getHost()));
                return;
            }
            PeerConnectInfo connectInfo = new PeerConnectInfo(torrent, InetSocketAddress.createUnresolved(hostname.get().asString(), (int)port.get().asLong()));
            this.connectPeer(connectInfo);
        });
    }

    @Override
    public void scrape() {
        throw new UnsupportedOperationException("HTTP trackers do not support scraping");
    }

    private String hexEncode(byte[] bytes) {
        StringBuilder stringBuilder = new StringBuilder();
        for (byte b : bytes) {
            stringBuilder.append("%");
            String encoded = Integer.toUnsignedString(Byte.toUnsignedInt(b), 16);
            if (encoded.length() == 1) {
                stringBuilder.append("0");
            }
            stringBuilder.append(encoded);
        }
        return stringBuilder.toString();
    }

    @Override
    public synchronized void addTorrent(Torrent torrent) {
        if (!this.torrentMap.containsKey(torrent)) {
            this.torrentMap.put(torrent, new TorrentInfo(torrent, this.clock));
        }
    }

    @Override
    public synchronized boolean hasTorrent(Torrent torrent) {
        return this.torrentMap.containsKey(torrent);
    }

    @Override
    public synchronized Optional<TorrentInfo> getInfo(Torrent torrent) {
        return Optional.ofNullable(this.torrentMap.get(torrent));
    }

    @Override
    public void connectPeer(PeerConnectInfo peer) {
        this.torrentClient.getPeerConnector().enqueuePeer(peer);
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public String getName() {
        return this.trackerUrl.getHost();
    }

    public long getAnnounceInterval() {
        return this.announceInterval;
    }

    public static final class Builder {
        private TorrentClient torrentClient;
        private String trackerUrl;

        public Builder setTorrentClient(TorrentClient torrentClient) {
            this.torrentClient = torrentClient;
            return this;
        }

        public Builder setUrl(String trackerUrl) {
            this.trackerUrl = trackerUrl;
            return this;
        }

        public HttpTracker build() {
            return new HttpTracker(this);
        }
    }
}

