/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.network;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.time.Clock;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Queue;
import org.johnnei.javatorrent.bittorrent.protocol.MessageFactory;
import org.johnnei.javatorrent.bittorrent.protocol.messages.IMessage;
import org.johnnei.javatorrent.bittorrent.protocol.messages.MessageBlock;
import org.johnnei.javatorrent.bittorrent.protocol.messages.MessageKeepAlive;
import org.johnnei.javatorrent.internal.network.TransferRate;
import org.johnnei.javatorrent.network.ByteBufferUtils;
import org.johnnei.javatorrent.network.InStream;
import org.johnnei.javatorrent.network.OutStream;
import org.johnnei.javatorrent.network.socket.ISocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitTorrentSocket {
    private static final Logger LOGGER = LoggerFactory.getLogger(BitTorrentSocket.class);
    private static final int MESSAGE_LENGTH_SIZE = 4;
    private static final int READ_BUFFER_SIZE = 16388;
    private final Object queueLock = new Object();
    private final Object blockQueueLock = new Object();
    private final Clock clock;
    private final ISocket socket;
    private final MessageFactory messageFactory;
    private final TransferRate downloadRate;
    private final TransferRate uploadRate;
    private Queue<IMessage> messageQueue;
    private Queue<IMessage> blockQueue;
    private ByteBuffer readBuffer;
    private ByteBuffer writeBuffer;
    private LocalDateTime lastBufferCreate;
    private LocalDateTime lastActivity;

    public BitTorrentSocket(MessageFactory messageFactory, ISocket socket) {
        this(messageFactory, socket, Clock.systemDefaultZone());
    }

    BitTorrentSocket(MessageFactory messageFactory, ISocket socket, Clock clock) {
        this.clock = clock;
        this.messageFactory = messageFactory;
        this.messageQueue = new LinkedList<IMessage>();
        this.blockQueue = new LinkedList<IMessage>();
        this.lastActivity = LocalDateTime.now(clock);
        this.socket = Objects.requireNonNull(socket, "Socket cannot be null");
        this.readBuffer = ByteBuffer.allocate(16388);
        this.readBuffer.limit(0);
        this.downloadRate = new TransferRate(clock);
        this.uploadRate = new TransferRate(clock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueMessage(IMessage message) {
        if (message instanceof MessageBlock) {
            Object object = this.blockQueueLock;
            synchronized (object) {
                this.blockQueue.add(message);
            }
        }
        Object object = this.queueLock;
        synchronized (object) {
            this.messageQueue.add(message);
        }
    }

    public IMessage readMessage() {
        InStream stream = this.getBufferedMessage();
        int length = stream.readInt();
        if (length == 0) {
            return new MessageKeepAlive();
        }
        byte id = stream.readByte();
        IMessage message = this.messageFactory.createById(id);
        message.read(stream);
        LOGGER.trace("Read message: {}", (Object)message);
        return message;
    }

    public void sendMessages() throws IOException {
        ByteBuffer buffer;
        while ((buffer = this.prepareMessageForSending()) != null) {
            int transferredBytes = ((WritableByteChannel)this.socket.getWritableChannel()).write(buffer);
            this.uploadRate.addTransferredBytes(transferredBytes);
            this.lastActivity = LocalDateTime.now(this.clock);
            if (buffer.hasRemaining()) {
                this.writeBuffer = buffer;
                return;
            }
            this.writeBuffer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer prepareMessageForSending() {
        Object object;
        if (this.writeBuffer != null) {
            return this.writeBuffer;
        }
        IMessage message = null;
        if (!this.messageQueue.isEmpty()) {
            object = this.queueLock;
            synchronized (object) {
                message = this.messageQueue.poll();
            }
        }
        if (!this.blockQueue.isEmpty()) {
            object = this.blockQueueLock;
            synchronized (object) {
                message = this.blockQueue.poll();
            }
        }
        if (message == null) {
            return null;
        }
        LOGGER.trace("Writing message {}", message);
        OutStream outBuffer = new OutStream(message.getLength() + 4);
        outBuffer.writeInt(message.getLength());
        if (message.getLength() > 0) {
            outBuffer.writeByte(message.getId());
            message.write(outBuffer);
        }
        return ByteBuffer.wrap(outBuffer.toByteArray());
    }

    public void pollRates() {
        this.downloadRate.pollRate();
        this.uploadRate.pollRate();
    }

    public void close() {
        if (this.socket.isClosed()) {
            return;
        }
        try {
            this.socket.close();
        }
        catch (IOException e) {
            LOGGER.warn("Failed to close socket.", (Throwable)e);
        }
    }

    public boolean canReadMessage() throws IOException {
        if (this.readBuffer.position() == 0) {
            this.lastBufferCreate = LocalDateTime.now(this.clock);
            this.readBuffer.limit(4);
        }
        this.readInput();
        if (this.readBuffer.position() >= 4) {
            ByteBuffer buffer = this.readBuffer.asReadOnlyBuffer();
            buffer.flip();
            int messageLength = buffer.getInt();
            int bytesNeeded = 4 + messageLength;
            if (this.readBuffer.capacity() < bytesNeeded) {
                this.growReadBuffer(bytesNeeded);
            }
            this.readBuffer.limit(bytesNeeded);
            if (this.readBuffer.hasRemaining()) {
                this.readInput();
            }
            return this.readBuffer.position() >= bytesNeeded;
        }
        return false;
    }

    private void readInput() throws IOException {
        int readBytes = ((ReadableByteChannel)this.socket.getReadableChannel()).read(this.readBuffer);
        if (readBytes == -1) {
            throw new IOException("Unexpected end of channel.");
        }
        this.downloadRate.addTransferredBytes(readBytes);
    }

    private void growReadBuffer(int desiredSize) {
        ByteBuffer buffer = ByteBuffer.allocate(desiredSize);
        this.readBuffer.flip();
        buffer.put(this.readBuffer);
        this.readBuffer = buffer;
    }

    private InStream getBufferedMessage() {
        this.readBuffer.flip();
        InStream messageStream = new InStream(ByteBufferUtils.getBytes(this.readBuffer, this.readBuffer.remaining()), this.getBufferLifetime());
        this.readBuffer.clear();
        return messageStream;
    }

    private Duration getBufferLifetime() {
        return Duration.between(this.lastBufferCreate, LocalDateTime.now(this.clock));
    }

    public int getDownloadRate() {
        return this.downloadRate.getRate();
    }

    public int getUploadRate() {
        return this.uploadRate.getRate();
    }

    public boolean closed() {
        return this.socket.isClosed();
    }

    public boolean hasOutboundMessages() {
        boolean hasPendingMessages;
        boolean bl = hasPendingMessages = !this.messageQueue.isEmpty() || !this.blockQueue.isEmpty();
        if (hasPendingMessages) {
            LOGGER.trace("Pending outbound messages [{}] blocks [{}]", (Object)this.messageQueue.size(), (Object)this.blockQueue.size());
        }
        return this.writeBuffer != null || hasPendingMessages;
    }

    public String getSocketName() {
        return this.socket.getClass().getSimpleName();
    }

    public String toString() {
        return String.format("BitTorrentSocket[socket=%s]", this.socket);
    }

    public LocalDateTime getLastActivity() {
        return this.lastActivity;
    }
}

