/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.network.socket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import org.johnnei.javatorrent.network.socket.ISocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NioTcpSocket
implements ISocket {
    private static final Logger LOGGER = LoggerFactory.getLogger(NioTcpSocket.class);
    private final SocketChannel channel;

    public NioTcpSocket(SocketChannel channel) {
        if (channel.isBlocking()) {
            throw new IllegalArgumentException("Only non-blocking Channels are supported.");
        }
        this.channel = channel;
    }

    public NioTcpSocket() {
        try {
            this.channel = SocketChannel.open();
            this.channel.configureBlocking(false);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create socket channel", e);
        }
    }

    @Override
    public void connect(InetSocketAddress endpoint) throws IOException {
        this.channel.connect(endpoint);
    }

    @Override
    public boolean isConnected() {
        if (this.channel.isConnectionPending()) {
            try {
                this.channel.finishConnect();
            }
            catch (IOException e) {
                LOGGER.debug("Failed to connect to remote.", (Throwable)e);
            }
        }
        return this.channel.isConnected();
    }

    public SocketChannel getReadableChannel() {
        return this.channel;
    }

    public SocketChannel getWritableChannel() {
        return this.channel;
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    @Override
    public boolean isClosed() {
        return !this.channel.isOpen();
    }

    @Override
    public boolean isInputShutdown() {
        return this.channel.isOpen();
    }

    @Override
    public boolean isOutputShutdown() {
        return this.channel.isOpen();
    }
}

