/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.phases;

import java.io.File;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.johnnei.javatorrent.TorrentClient;
import org.johnnei.javatorrent.bittorrent.tracker.TrackerEvent;
import org.johnnei.javatorrent.phases.IDownloadPhase;
import org.johnnei.javatorrent.torrent.Torrent;
import org.johnnei.javatorrent.torrent.TorrentException;
import org.johnnei.javatorrent.torrent.algos.choking.IChokingStrategy;
import org.johnnei.javatorrent.torrent.algos.choking.PermissiveStrategy;
import org.johnnei.javatorrent.torrent.algos.pieceselector.FullPieceSelect;
import org.johnnei.javatorrent.torrent.files.Block;
import org.johnnei.javatorrent.torrent.files.BlockStatus;
import org.johnnei.javatorrent.torrent.files.Piece;
import org.johnnei.javatorrent.torrent.peer.Peer;
import org.johnnei.javatorrent.torrent.peer.PeerDirection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhaseData
implements IDownloadPhase {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhaseData.class);
    private final Torrent torrent;
    private final TorrentClient torrentClient;
    private final IChokingStrategy chokingStrategy;

    public PhaseData(TorrentClient torrentClient, Torrent torrent) {
        this.torrentClient = torrentClient;
        this.torrent = torrent;
        this.chokingStrategy = new PermissiveStrategy();
    }

    @Override
    public boolean isDone() {
        return this.torrent.getFileSet().isDone();
    }

    @Override
    public void process() {
        this.getRelevantPeers(this.torrent.getPeers()).forEach(peer -> {
            Optional<Piece> piece;
            while (peer.getFreeWorkTime() > 0 && (piece = this.torrent.getPieceSelector().getPieceForPeer((Peer)peer)).isPresent()) {
                this.requestBlocksOfPiece((Peer)peer, piece.get());
            }
        });
    }

    private void requestBlocksOfPiece(Peer peer, Piece piece) {
        Optional<Block> blockOptional;
        while (peer.getFreeWorkTime() > 0 && (blockOptional = piece.getRequestBlock()).isPresent()) {
            Block block = blockOptional.get();
            if (!peer.addBlockRequest(piece, this.torrent.getFileSet().getBlockSize() * block.getIndex(), block.getSize(), PeerDirection.Download)) continue;
            block.setStatus(BlockStatus.Requested);
        }
    }

    @Override
    public void onPhaseEnter() {
        this.torrent.checkProgress();
        this.torrent.setPieceSelector(new FullPieceSelect(this.torrent));
        File downloadFolder = this.torrent.getFileSet().getDownloadFolder();
        if (!downloadFolder.exists() && !downloadFolder.mkdirs()) {
            throw new TorrentException(String.format("Failed to create download folder: %s", downloadFolder.getAbsolutePath()));
        }
    }

    @Override
    public void onPhaseExit() {
        this.torrentClient.getTrackersFor(this.torrent).forEach(tracker -> tracker.getInfo(this.torrent).get().setEvent(TrackerEvent.EVENT_COMPLETED));
        LOGGER.info("Download of {} completed", (Object)this.torrent);
    }

    Stream<Peer> getRelevantPeers(Collection<Peer> peers) {
        Collection neededPiece = this.torrent.getFileSet().getNeededPieces().collect(Collectors.toList());
        return peers.stream().filter(peer -> !peer.isChoked(PeerDirection.Download)).filter(peer -> neededPiece.stream().anyMatch(piece -> peer.hasPiece(piece.getIndex())));
    }

    @Override
    public IChokingStrategy getChokingStrategy() {
        return this.chokingStrategy;
    }
}

