/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.phases;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import org.johnnei.javatorrent.TorrentClient;
import org.johnnei.javatorrent.phases.IDownloadPhase;
import org.johnnei.javatorrent.torrent.Torrent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhaseRegulator {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhaseRegulator.class);
    private Class<? extends IDownloadPhase> initialPhase;
    private Map<Class<? extends IDownloadPhase>, Class<? extends IDownloadPhase>> downloadPhasesOrder;
    private Map<Class<? extends IDownloadPhase>, BiFunction<TorrentClient, Torrent, ? extends IDownloadPhase>> phaseSupplier;

    private PhaseRegulator(Builder builder) {
        this.initialPhase = builder.initialPhase;
        this.downloadPhasesOrder = builder.downloadPhasesOrder;
        this.phaseSupplier = builder.phaseSuppliers;
    }

    public IDownloadPhase createInitialPhase(TorrentClient torrentClient, Torrent torrent) {
        return this.phaseSupplier.get(this.initialPhase).apply(torrentClient, torrent);
    }

    public Optional<IDownloadPhase> createNextPhase(IDownloadPhase phase, TorrentClient torrentClient, Torrent torrent) {
        if (!this.downloadPhasesOrder.containsKey(phase.getClass())) {
            return Optional.empty();
        }
        return Optional.of(this.phaseSupplier.get(this.downloadPhasesOrder.get(phase.getClass())).apply(torrentClient, torrent));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("PhaseRegulator[");
        Class<? extends IDownloadPhase> type = this.initialPhase;
        while (type != null) {
            stringBuilder.append(type.getSimpleName());
            if ((type = this.downloadPhasesOrder.get(type)) == null) continue;
            stringBuilder.append(" -> ");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static class Builder {
        private Class<? extends IDownloadPhase> initialPhase;
        private Map<Class<? extends IDownloadPhase>, Class<? extends IDownloadPhase>> downloadPhasesOrder = new HashMap<Class<? extends IDownloadPhase>, Class<? extends IDownloadPhase>>();
        private Map<Class<? extends IDownloadPhase>, BiFunction<TorrentClient, Torrent, ? extends IDownloadPhase>> phaseSuppliers = new HashMap<Class<? extends IDownloadPhase>, BiFunction<TorrentClient, Torrent, ? extends IDownloadPhase>>();

        public <T extends IDownloadPhase> Builder registerInitialPhase(Class<T> phase, BiFunction<TorrentClient, Torrent, T> phaseSupplier) {
            return this.registerInitialPhase(phase, phaseSupplier, null);
        }

        public <T extends IDownloadPhase> Builder registerInitialPhase(Class<T> phase, BiFunction<TorrentClient, Torrent, T> phaseSupplier, Class<? extends IDownloadPhase> nextPhase) {
            if (this.initialPhase != null) {
                LOGGER.warn(String.format("Overriding initial download phase from %s to %s", this.initialPhase.getSimpleName(), phase.getSimpleName()));
            }
            this.initialPhase = phase;
            this.registerPhase(phase, phaseSupplier, nextPhase);
            return this;
        }

        public <T extends IDownloadPhase> Builder registerPhase(Class<T> phase, BiFunction<TorrentClient, Torrent, T> phaseSupplier) {
            return this.registerPhase(phase, phaseSupplier, null);
        }

        public <T extends IDownloadPhase> Builder registerPhase(Class<T> phase, BiFunction<TorrentClient, Torrent, T> phaseSupplier, Class<? extends IDownloadPhase> nextPhase) {
            Objects.requireNonNull(phase, "Phase is required.");
            Objects.requireNonNull(phaseSupplier, "Phase supplier is required.");
            if (this.phaseSuppliers.containsKey(phase)) {
                throw new IllegalStateException(String.format("Phase %s is already mapped", phase.getSimpleName()));
            }
            if (nextPhase != null) {
                this.downloadPhasesOrder.put(phase, nextPhase);
            }
            this.phaseSuppliers.put(phase, phaseSupplier);
            return this;
        }

        public PhaseRegulator build() {
            if (this.initialPhase == null) {
                throw new IllegalStateException("No initial state has been configured.");
            }
            this.verifyPhaseChain();
            return new PhaseRegulator(this);
        }

        private void verifyPhaseChain() {
            int phasesSeenCount = 0;
            Class<? extends IDownloadPhase> phase = this.initialPhase;
            while (phase != null) {
                ++phasesSeenCount;
                phase = this.downloadPhasesOrder.get(phase);
            }
            if (phasesSeenCount != this.phaseSuppliers.size()) {
                LOGGER.warn(String.format("Download phases chain does not contain all registered types. Registered: %d, in chain: %d.", this.phaseSuppliers.size(), phasesSeenCount));
            }
        }
    }
}

