/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.phases;

import org.johnnei.javatorrent.TorrentClient;
import org.johnnei.javatorrent.phases.IDownloadPhase;
import org.johnnei.javatorrent.torrent.Torrent;
import org.johnnei.javatorrent.torrent.algos.choking.IChokingStrategy;
import org.johnnei.javatorrent.torrent.algos.choking.PermissiveUploadStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhaseSeed
implements IDownloadPhase {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhaseSeed.class);
    private final Torrent torrent;
    private IChokingStrategy chokingStrategy;

    public PhaseSeed(TorrentClient torrentClient, Torrent torrent) {
        this.torrent = torrent;
        this.chokingStrategy = new PermissiveUploadStrategy();
    }

    @Override
    public boolean isDone() {
        return false;
    }

    @Override
    public void process() {
        this.torrent.getPeers().stream().filter(p -> p.countHavePieces() == this.torrent.getFileSet().getPieceCount()).forEach(p -> p.getBitTorrentSocket().close());
    }

    @Override
    public void onPhaseEnter() {
    }

    @Override
    public void onPhaseExit() {
        LOGGER.info("Upload target reached");
    }

    @Override
    public IChokingStrategy getChokingStrategy() {
        return this.chokingStrategy;
    }
}

