/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.torrent;

import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.johnnei.javatorrent.torrent.FileInfo;
import org.johnnei.javatorrent.torrent.files.BlockStatus;
import org.johnnei.javatorrent.torrent.files.IFileSetRequestFactory;
import org.johnnei.javatorrent.torrent.files.Piece;
import org.johnnei.javatorrent.utils.Argument;
import org.johnnei.javatorrent.utils.MathUtils;

public abstract class AbstractFileSet {
    protected List<Piece> pieces;
    protected List<FileInfo> fileInfos;
    private final int blockSize;

    public AbstractFileSet(int blockSize) {
        this.blockSize = blockSize;
    }

    public boolean hasPiece(int pieceIndex) {
        Argument.requireWithinBounds(pieceIndex, 0, this.pieces.size(), String.format("Piece #%d is not within this file set.", pieceIndex));
        return this.pieces.get(pieceIndex).isDone();
    }

    public void setHavingPiece(int pieceIndex) {
        Piece piece = this.pieces.get(pieceIndex);
        for (int i = 0; i < piece.getBlockCount(); ++i) {
            piece.setBlockStatus(i, BlockStatus.Verified);
        }
    }

    public FileInfo getFileForBytes(int pieceIndex, int blockIndex, int byteOffset) {
        this.validateGetFileForBytes(pieceIndex, blockIndex, byteOffset);
        long bytesStartPosition = (long)pieceIndex * this.getPieceSize() + (long)(blockIndex * this.getBlockSize()) + (long)byteOffset;
        for (int i = this.fileInfos.size() - 1; i >= 0; --i) {
            FileInfo fileInfo = this.fileInfos.get(i);
            if (fileInfo.getFirstByteOffset() > bytesStartPosition) continue;
            return fileInfo;
        }
        throw new IllegalArgumentException("Piece is not within fileset.");
    }

    private void validateGetFileForBytes(int pieceIndex, int blockIndex, int byteOffset) {
        Argument.requireWithinBounds(pieceIndex, 0, this.pieces.size(), () -> String.format("Piece %d is not within the file set.", pieceIndex));
        Argument.requirePositive(blockIndex, "Block index cannot be negative.");
        Argument.requirePositive(byteOffset, "Byte offset cannot be negative.");
        if (byteOffset >= this.getBlockSize()) {
            throw new IllegalArgumentException("Byte offset is out of range (larger or equal to block size).");
        }
        if ((long)blockIndex >= MathUtils.ceilDivision(this.getPieceSize(), (long)this.getBlockSize())) {
            throw new IllegalArgumentException("Block index out of range (is larger or equal to piece size).");
        }
    }

    public Piece getPiece(int index) {
        Argument.requireWithinBounds(index, 0, this.pieces.size(), String.format("Piece %s is outside of the file set.", index));
        return this.pieces.get(index);
    }

    public abstract IFileSetRequestFactory getRequestFactory();

    public abstract long getPieceSize();

    public int getBlockSize() {
        return this.blockSize;
    }

    public boolean isDone() {
        return this.pieces.stream().allMatch(Piece::isDone);
    }

    public Stream<Piece> getNeededPieces() {
        return this.pieces.stream().filter(p -> !p.isDone());
    }

    public int getPieceCount() {
        return this.pieces.size();
    }

    public long getTotalFileSize() {
        return this.fileInfos.stream().mapToLong(FileInfo::getSize).sum();
    }

    public long countRemainingBytes() {
        return this.pieces.stream().mapToLong(Piece::countRemainingBytes).sum();
    }

    public int countCompletedPieces() {
        return (int)this.pieces.stream().filter(Piece::isDone).count();
    }

    public abstract byte[] getBitfieldBytes();

    public List<FileInfo> getFiles() {
        return Collections.unmodifiableList(this.fileInfos);
    }
}

