/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.torrent;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.johnnei.javatorrent.torrent.fileset.FileEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileInfo.class);
    private final FileEntry fileEntry;
    private int pieceCount;
    private RandomAccessFile fileAccess;
    public final Object fileLock = new Object();

    public FileInfo(long filesize, long firstByteOffset, File file, int pieceCount) {
        this.fileEntry = new FileEntry(file.getName(), filesize, firstByteOffset);
        this.pieceCount = pieceCount;
        try {
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            this.fileAccess = new RandomAccessFile(file, "rw");
        }
        catch (IOException ex) {
            LOGGER.warn("Failed to open read/write access to {}", (Object)file.getAbsolutePath(), (Object)ex);
        }
    }

    public int getPieceCount() {
        return this.pieceCount;
    }

    public long getSize() {
        return this.fileEntry.getSize();
    }

    public long getFirstByteOffset() {
        return this.fileEntry.getFirstByteOffset();
    }

    public String getFileName() {
        return this.fileEntry.getFileName();
    }

    public RandomAccessFile getFileAccess() {
        return this.fileAccess;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof FileInfo)) {
            return false;
        }
        return this.fileEntry.equals(((FileInfo)o).fileEntry);
    }

    public int hashCode() {
        return this.fileEntry.hashCode();
    }

    public String toString() {
        return String.format("FileInfo[entry=%s, pieceCount=%d]", this.fileEntry.toString(), this.pieceCount);
    }
}

