/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.torrent;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.johnnei.javatorrent.internal.torrent.TorrentFileSetRequestFactory;
import org.johnnei.javatorrent.internal.torrent.peer.Bitfield;
import org.johnnei.javatorrent.torrent.AbstractFileSet;
import org.johnnei.javatorrent.torrent.FileInfo;
import org.johnnei.javatorrent.torrent.Metadata;
import org.johnnei.javatorrent.torrent.files.Piece;
import org.johnnei.javatorrent.torrent.fileset.FileEntry;
import org.johnnei.javatorrent.utils.Argument;
import org.johnnei.javatorrent.utils.MathUtils;

public class TorrentFileSet
extends AbstractFileSet {
    private static final int BLOCK_SIZE = 16384;
    private final TorrentFileSetRequestFactory requestFactory;
    private final Metadata metadata;
    private File downloadFolder;
    private Bitfield bitfield;

    public TorrentFileSet(Metadata metadata, File downloadFolder) {
        super(16384);
        this.metadata = Argument.requireNonNull(metadata, "Torrent metadata can not be null");
        this.downloadFolder = Argument.requireNonNull(downloadFolder, "Download folder cannot be null");
        this.requestFactory = new TorrentFileSetRequestFactory();
        long remainingSize = 0L;
        this.fileInfos = new ArrayList(metadata.getFileEntries().size());
        for (FileEntry fileEntry : metadata.getFileEntries()) {
            int pieceCount = (int)MathUtils.ceilDivision(fileEntry.getSize(), metadata.getPieceSize());
            FileInfo info = new FileInfo(fileEntry.getSize(), fileEntry.getFirstByteOffset(), this.getFile(fileEntry.getFileName()), pieceCount);
            this.fileInfos.add(info);
            remainingSize += fileEntry.getSize();
        }
        this.pieces = new ArrayList(metadata.getPieceHashes().size());
        List<byte[]> pieceHashes = metadata.getPieceHashes();
        for (int index = 0; index < pieceHashes.size(); ++index) {
            int pieceSize = (int)Math.min(remainingSize, metadata.getPieceSize());
            this.pieces.add(new Piece(this, pieceHashes.get(index), index, pieceSize, 16384));
            remainingSize -= (long)pieceSize;
        }
        this.bitfield = new Bitfield(this.getBitfieldSize());
    }

    @Override
    public void setHavingPiece(int pieceIndex) {
        super.setHavingPiece(pieceIndex);
        this.bitfield.havePiece(pieceIndex);
    }

    private int getBitfieldSize() {
        return (int)Math.ceil((double)this.pieces.size() / 8.0);
    }

    private File getFile(String name) {
        return new File(this.downloadFolder, name);
    }

    @Override
    public long getPieceSize() {
        return this.metadata.getPieceSize();
    }

    @Override
    public byte[] getBitfieldBytes() {
        return this.bitfield.getBytes();
    }

    @Override
    public TorrentFileSetRequestFactory getRequestFactory() {
        return this.requestFactory;
    }

    public File getDownloadFolder() {
        return this.downloadFolder;
    }
}

