/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.torrent.algos.pieceselector;

import java.util.Optional;
import org.johnnei.javatorrent.torrent.Torrent;
import org.johnnei.javatorrent.torrent.algos.pieceselector.IPieceSelector;
import org.johnnei.javatorrent.torrent.files.BlockStatus;
import org.johnnei.javatorrent.torrent.files.Piece;
import org.johnnei.javatorrent.torrent.peer.Peer;

public class FullPieceSelect
implements IPieceSelector {
    private Torrent torrent;

    public FullPieceSelect(Torrent torrent) {
        this.torrent = torrent;
    }

    private int countAvailability(Piece piece) {
        return (int)this.torrent.getPeers().stream().filter(peer -> peer.hasPiece(piece.getIndex())).count();
    }

    private int comparePieces(CachedPiece a, CachedPiece b) {
        if (a.isStarted() == b.isStarted()) {
            return a.getAvailability() - b.getAvailability();
        }
        if (a.isStarted() && !b.isStarted()) {
            return -1;
        }
        return 1;
    }

    @Override
    public Optional<Piece> getPieceForPeer(Peer peer) {
        return this.torrent.getFileSet().getNeededPieces().filter(piece -> piece.hasBlockWithStatus(BlockStatus.Needed)).filter(piece -> peer.hasPiece(piece.getIndex())).map(piece -> new CachedPiece((Piece)piece, this.countAvailability((Piece)piece))).sorted(this::comparePieces).map(CachedPiece::getPiece).findFirst();
    }

    private class CachedPiece {
        private final Piece piece;
        private final boolean isStarted;
        private final int availability;

        CachedPiece(Piece piece, int availability) {
            this.piece = piece;
            this.availability = availability;
            this.isStarted = piece.isStarted();
        }

        Piece getPiece() {
            return this.piece;
        }

        boolean isStarted() {
            return this.isStarted;
        }

        int getAvailability() {
            return this.availability;
        }
    }
}

