/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.torrent.algos.requests;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.LinkedList;
import java.util.List;
import java.util.OptionalDouble;
import org.johnnei.javatorrent.bittorrent.protocol.messages.MessageBlock;
import org.johnnei.javatorrent.torrent.algos.requests.IRequestLimiter;
import org.johnnei.javatorrent.torrent.peer.Peer;

public class RateBasedLimiter
implements IRequestLimiter {
    private final Clock clock = Clock.systemDefaultZone();
    private static final int MAX_DECREASE = -2;
    private static final int MAX_INCREASE = 25;

    @Override
    public void onReceivedBlock(Peer peer, MessageBlock messageBlock) {
        messageBlock.getReadDuration().ifPresent(duration -> {
            RateInfo rateInfo = this.getRateInfo(peer);
            rateInfo.addEntry(this.clock, (Duration)duration);
            rateInfo.getAverage(this.clock).ifPresent(avg -> {
                int blocksPerSecond = (int)((double)Duration.ofSeconds(1L).toMillis() / Math.max(Double.MIN_NORMAL, avg));
                int diff = 3 * blocksPerSecond - peer.getRequestLimit();
                diff = diff < 0 ? Math.max(diff, -2) : Math.min(diff, 25);
                peer.setRequestLimit(Math.max(1, peer.getRequestLimit() + diff));
            });
        });
    }

    private RateInfo getRateInfo(Peer peer) {
        return peer.getModuleInfo(RateInfo.class).orElseGet(() -> {
            RateInfo rateInfo = new RateInfo();
            peer.addModuleInfo(rateInfo);
            return rateInfo;
        });
    }

    private static class RateEntry {
        private final Instant timestamp;
        private final Duration readTime;

        RateEntry(Instant instant, Duration readTime) {
            this.readTime = readTime;
            this.timestamp = instant;
        }
    }

    private static class RateInfo {
        private final List<RateEntry> readTimes = new LinkedList<RateEntry>();

        RateInfo() {
        }

        void addEntry(Clock clock, Duration readTime) {
            this.readTimes.add(new RateEntry(clock.instant(), readTime));
        }

        OptionalDouble getAverage(Clock clock) {
            this.cleanReadTimes(clock);
            return this.readTimes.stream().mapToLong(e -> ((RateEntry)e).readTime.toMillis()).average();
        }

        private void cleanReadTimes(Clock clock) {
            Instant recentItems = clock.instant().minusSeconds(5L);
            this.readTimes.removeIf(e -> ((RateEntry)e).timestamp.isBefore(recentItems));
        }
    }
}

